#include "Sequence/Debug/Input/DebugSequenceInputJoystick.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Sequence::Debug::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceInputJoystick::DebugSequenceInputJoystick()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceInputJoystick::~DebugSequenceInputJoystick()
{
}

/// `
void DebugSequenceInputJoystick::Render()
{
	// WCXeBbN擾
	IJoystick* pJoystick = InputManagerHelper::GetJoystick();

	// {^Ă邩ǂ
	bool isDownButtons[Buttons::eBUTTON_COUNT];
	for (int i = 0; i < Buttons::eBUTTON_COUNT; ++i)
	{
		// CfbNX񋓑̂ɕϊ
		Buttons::EButton eButton = static_cast<Buttons::EButton>(i);

		// Ă邩ǂ擾
		isDownButtons[i] = pJoystick->IsDown(eButton);
	}

	// XeBbŇX|ʂ擾
	int tiltXLS = pJoystick->GetStickTiltX(Sticks::eSTICK_LEFT);
	int tiltYLS = pJoystick->GetStickTiltY(Sticks::eSTICK_LEFT);

	// EXeBbŇX|ʂ擾
	int tiltXRS = pJoystick->GetStickTiltX(Sticks::eSTICK_RIGHT);
	int tiltYRS = pJoystick->GetStickTiltY(Sticks::eSTICK_RIGHT);

	// XeBbŇX|͂擾
	bool isTiltPlusXLS = pJoystick->IsStickTiltPlusX(Sticks::eSTICK_LEFT, 5000);
	bool isTiltMinusXLS = pJoystick->IsStickTiltMinusX(Sticks::eSTICK_LEFT, -5000);
	bool isTiltPlusYLS = pJoystick->IsStickTiltPlusY(Sticks::eSTICK_LEFT, 5000);
	bool isTiltMinusYLS = pJoystick->IsStickTiltMinusY(Sticks::eSTICK_LEFT, -5000);

	// EXeBbŇX|͂擾
	bool isTiltPlusXRS = pJoystick->IsStickTiltPlusX(Sticks::eSTICK_RIGHT, 5000);
	bool isTiltMinusXRS = pJoystick->IsStickTiltMinusX(Sticks::eSTICK_RIGHT, -5000);
	bool isTiltPlusYRS = pJoystick->IsStickTiltPlusY(Sticks::eSTICK_RIGHT, 5000);
	bool isTiltMinusYRS = pJoystick->IsStickTiltMinusY(Sticks::eSTICK_RIGHT, -5000);


	// ʒu
	int x = 0;
	int y = 0;

	// s
	int lineSpacing = 16;

	// sCfbNX
	int lineIndex = 0;

	// V[PX̐
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffff00, _T("<WCXeBbN̓͏>"));

	// Ă{^\
	y = lineSpacing * lineIndex++;
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("Ă{^"));

	// {^̐Ń[v
	for (int i = 0; i < Buttons::eBUTTON_COUNT; ++i)
	{
		// Ă邩ǂ擾
		bool isDown = isDownButtons[i];

		// ĂȂ
		if (isDown)
		{
			// ̋Ԃ`
			const int kSpacing = 20;

			// Xʒů
			const int kBaseX = 100;

			// Xʒuݒ
			x = kSpacing * i + kBaseX;

			// \
			DP(x, y, 0xff00ff00, _T("[%2d]"), i);
		}
	}

	x = 0;

	// XeBbŇX|ʂ\
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("XeBbN(%d, %d)"), tiltXLS, tiltYLS);

	// EXeBbŇX|ʂ\
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("EXeBbN(%d, %d)"), tiltXRS, tiltYRS);

	// XeBbŇX|͂\
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("XeBbN+XX|:%s"), isTiltPlusXLS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("XeBbN-XX|:%s"), isTiltMinusXLS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("XeBbN+YX|:%s"), isTiltPlusYLS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("XeBbN-YX|:%s"), isTiltMinusYLS ? _T("True") : _T("False"));

	// EXeBbŇX|͂\
	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("EXeBbN+XX|:%s"), isTiltPlusXRS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("EXeBbN-XX|:%s"), isTiltMinusXRS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("EXeBbN+YX|:%s"), isTiltPlusYRS ? _T("True") : _T("False"));

	y = lineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("EXeBbN-YX|:%s"), isTiltMinusYRS ? _T("True") : _T("False"));
}