#include "Sequence/Debug/DebugSequenceType.h"

using namespace Sequence::Debug;
using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceType::DebugSequenceType()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceType::~DebugSequenceType()
{
}


/// `
void DebugSequenceType::Render()
{
	// `Jnʒu
	const int kBaseX = 50;
	const int kBaseY = 50;

	// `ʒu
	int x = kBaseX;
	int y = kBaseY;

	// o̐F
	unsigned subheadColor = 0xff88ff44;

	// oƏ̍s
	const int subheadSpacing = 15;


	// Int8ZoȂ`
	x += 0;
	y += 0;
	DP(x, y, subheadColor, _T("<Int8>"));
	RenderType<Int8>(x, y + subheadSpacing);
	

	// Int16ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<Int16>"));
	RenderType<Int16>(x, y + subheadSpacing);


	// Int32ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<Int32>"));
	RenderType<Int32>(x, y + subheadSpacing);

	
	// Int64ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<Int64>"));
	RenderType<Int64>(x, y + subheadSpacing);


	// ʒuZbg
	ResetRenderPosition(x, y, kBaseX, kBaseY);

	
	// UInt8ZoȂ`
	x += 0;
	y += 100;
	DP(x, y, subheadColor, _T("<UInt8>"));
	RenderType<UInt8>(x, y + subheadSpacing);

	
	// UInt16ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<UInt16>"));
	RenderType<UInt16>(x, y + subheadSpacing);

	
	// UInt32ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<UInt32>"));
	RenderType<UInt32>(x, y + subheadSpacing);


	// UInt64ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<UInt64>"));
	RenderType<UInt64>(x, y + subheadSpacing);

	
	// ʒuZbg
	ResetRenderPosition(x, y, kBaseX, kBaseY);


	// Float32ZoȂ`
	x += 0;
	y += 200;
	DP(x, y, subheadColor, _T("<Float32>"));
	RenderType<Float32>(x, y + subheadSpacing);


	// Float64ZoȂ`
	x += 150;
	y += 0;
	DP(x, y, subheadColor, _T("<Float64>"));
	RenderType<Float64>(x, y + subheadSpacing);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// `ʒuZo
void DebugSequenceType::CalcurateRenderPositionY(int& rOutY, int& rLineIndex, int addLineIndex)
{
	// s
	const int kLineSpacing = 12;

	// sCfbNXZ
	rLineIndex += addLineIndex;

	// ʒuZo
	rOutY = kLineSpacing * rLineIndex;
}

/// `ʒuZbg
void DebugSequenceType::ResetRenderPosition(int& rX, int&rY, int baseX, int baseY)
{
	rX = baseX;
	rY = baseY;
}