#include "Sequence/Debug/DebugSequenceTextRenderer.h"

#include "Blast/Graphic/IFont.h"
#include "Blast/Graphic/DirectX9/FontDX9.h"
#include "Blast/Graphic/DirectX9/SpriteFontDX9.h"
#include "Blast/Graphic/TextRendererColorTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::String;
using namespace Sequence::Debug;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// eLXgQ
const TCHAR* DebugSequenceTextRenderer::mStKPTexts[] =
{
	_T("0123456789"),
	_T("A0123456789"),
	_T("F̕ύX͓ŏoƂłˁB"),
	_T("FύX#ffffff00C[W#ffffffff#ff000000Unity#ffffffffۂ̂ǂł傤B"),
	_T("###"),
	_T("ȁA\nȂ񂾂ā[I"),
	_T("#ff000000ȂĂ#"),
	_T("soƑf炵łˁB"),
	_T("c̗L͕Kvł傤B"),
	_T("{A.F.1282180łB"),
	_T("#44000000S[Xg#ffffffff#ffff0000Zt#ffffffff#44000000#ffffffffƂoł܂ˁB"),
	_T("dummy"),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceTextRenderer::DebugSequenceTextRenderer()
	: SequenceBase(false)
{
	// JڎԂݒ
	mTransitionOnTime = 1.0;
	mTransitionOffTime = 0.5;


	// J쐬
	mPCamera.SetPointer(NEW Camera2D());


	// tHg쐬
	SP<FontDX9> pFont(NEW FontDX9());
	pFont->CreateFontData(_T("HGSE"), 36, 100);

	//// XvCgtHg쐬
	//SP<SpriteFontDX9> pFont(NEW SpriteFontDX9(_T("HGSE"), 36, 100));
	//pFont->SetCamera(mPCamera);

	//pFont->GetSprite()->GetShaderEffect()->SetTechnique(ShaderEffectDX9::eTECHNIQUE_SOLID);


	// eLXg_[쐬
	mPTextRenderer = NEW TextRendererColorTag(pFont);
}

/// fXgN^
DebugSequenceTextRenderer::~DebugSequenceTextRenderer()
{
	// eLXg_[
	SAFE_DELETE(mPTextRenderer);
}

/// 
void DebugSequenceTextRenderer::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[ݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceTextRenderer");


	// fobOj[Gg[Xg쐬
	MenuEntryListScroll* pDMEL = NEW MenuEntryListScroll();
	pDMEL->GetPropertyRef().mNameStr = _T("eLXg");

	// fobOj[ɃGg[Xgǉ
	mPDebugMenu->AddMenuEntryList(SP<MenuEntryListScroll>(pDMEL));

	
	// eLXg̐Ń[v
	int textCount = sizeof(mStKPTexts) / sizeof(mStKPTexts[0]);
	for (int i = 0; i < textCount; ++i)
	{
		// fobOj[Gg[쐬
		SP<MenuEntry> pDMEText(NEW MenuEntry());
		pDMEText->SetText(mStKPTexts[i]);

		pDMEL->AddMenuEntry(SP<IMenuEntry>(pDMEText));
	}


	// JQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera, mPGameComponents);


	// eLXg_[̈ʒuݒ
	mPTextRenderer->SetPosition(Vector3::UnitY() * 200.0f);

	// eLXgݒ
	mPTextRenderer->SetText(_T("eLXgIĕ͂ύXł܂B"));
}

/// 
void DebugSequenceTextRenderer::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// ړ
	int moveDirectionX = 0;
	int moveDirectionY = 0;

	// AĂȂ
	if (pKB->IsDown(Keys::eKEY_A))
	{
		moveDirectionX = -1;
	}
	// DĂȂ
	else if (pKB->IsDown(Keys::eKEY_D))
	{
		moveDirectionX = 1;
	}

	// WĂȂ
	if (pKB->IsDown(Keys::eKEY_W))
	{
		moveDirectionY = -1;
	}
	// SĂȂ
	else if (pKB->IsDown(Keys::eKEY_S))
	{
		moveDirectionY = 1;
	}

	// ړx
	const int kMoveSpeedX = 2;
	const int kMoveSpeedY = 1;

	// ʒuύX
	Vector3 pos = mPTextRenderer->GetPosition();
	pos.mX += moveDirectionX * kMoveSpeedX;
	pos.mY += moveDirectionY * kMoveSpeedY;
	mPTextRenderer->SetPosition(pos);


	// EnterL[ꂽȂ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// IĂGg[Xg擾
		SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();
		if (pMEL)
		{
			// IĂGg[̃CfbNX擾
			int selectedIndex = pMEL->GetSelectedIndex();

			// eLXgQ
			const TCHAR* kPText = mStKPTexts[selectedIndex];

			// eLXgݒ
			mPTextRenderer->SetText(kPText);
		}
	}
}

/// `
void DebugSequenceTextRenderer::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// eLXg_[̕`
	mPTextRenderer->Render();


	// Jڈʒu`
	Color dpColor = 0xff000000;
	dpColor.mAlpha = static_cast<float>(1 * mTransitionPosition);
	DP(10, 500, dpColor.GetARGB(), _T("Jڈʒu:%lf"), mTransitionPosition);
}