#include "Sequence/Debug/DebugSequenceSprite.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Graphic/RenderOrderCriteria.h"
#include "Blast/Math/MathHelper.h"

#include "Blast/Graphic/SpriteBatch.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ǂݍރeNX`̃pXQ
const TCHAR* DebugSequenceSprite::stKPTextureFilePaths[] =
{
	_T("./Res/Test/Texture/64x64_Tilshe.png"),
	_T("./Res/Test/Texture/Reimu.jpg"),
};

/// eNX`̃pX̐
const int DebugSequenceSprite::stKTextureFilePathCount = SIZE_OF_ARRAY(stKPTextureFilePaths);


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceSprite::DebugSequenceSprite()
	: SequenceBase(false)
{
	// XvCg2DAj[V쐬
	mPSprite2DAnimation.SetPointer(NEW SpriteAnimationDX9());


	// 2DJ쐬
	mPCamera2D.SetPointer(NEW Camera2D());
}

/// fXgN^
DebugSequenceSprite::~DebugSequenceSprite()
{
}


/// 
void DebugSequenceSprite::Initialize()
{
	// ̏
	SequenceBase::Initialize();

	// \[X}l[W[擾
	ResourceManager* pRM = ResourceManager::GetInstance();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceSprite>");


	// SpriteImage쐬
	for (int i = 0; i < stKTextureFilePathCount; ++i)
	{
		// C[W쐬
		SP<SpriteImage> pImage(NEW SpriteImage());
		mImages.push_back(pImage);

		// eNX`쐬
		SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
		pTex->Load(stKPTextureFilePaths[i]);

		pImage->SetTexture(pTex);
		pImage->FitSizeToTextureSize();
	}

	// eNX`̐Ń[v
	for (int i = 0; i < stKTextureFilePathCount; ++i)
	{
		// XvCg쐬
		SP<SpriteDX9> pSprite(NEW SpriteDX9());
		mPSprites.push_back(pSprite);

		// eNX`ݒ
		SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
		pTex->Load(stKPTextureFilePaths[i]);

		pSprite->SetTexture(pTex);

		pSprite->SetPosition(200.0f * i, 0, 0);			// ʒuݒ
		pSprite->SetSize(Vector2::One() * 128);			// TCYݒ
		pSprite->FitTextureSourceRectangle();			// öݒ
		pSprite->SetOrigin(SpriteDX9::eORIGIN_CENTER);	// _ݒ

		// Jݒ
		pSprite->SetCamera(mPCamera2D);
	}


	// XvCg2DAj[VQ[R|[lgɒǉ
	mPGameComponents->Add(mPSprite2DAnimation);

	// eNX`ݒ
	SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
	pTex->Load(_T("./Res/Test/Texture/Mana.png"));

	mPSprite2DAnimation->SetTexture(pTex);

	// TCYݒ
	mPSprite2DAnimation->SetSize(Vector2::One() * 128);

	// ʒuݒ
	mPSprite2DAnimation->SetPosition(400, 0, 0);

	// öݒ
	const int kSprite2DSrcCount = 2;
	SpriteAnimationDX9::SSourceRectangle mSRs[kSprite2DSrcCount];
	mSRs[0].mRectangle.mTopX = 0;
	mSRs[0].mRectangle.mTopY = 0;
	mSRs[0].mRectangle.SetWidth(100);
	mSRs[0].mRectangle.SetHeight(100);
	mSRs[0].mDurationTime = 0.25f;

	mSRs[1].mRectangle.mTopX = 100;
	mSRs[1].mRectangle.mTopY = 0;
	mSRs[1].mRectangle.SetWidth(100);
	mSRs[1].mRectangle.SetHeight(100);
	mSRs[1].mDurationTime = 1;

	for (int i = 0; i < kSprite2DSrcCount; ++i)
	{
		mPSprite2DAnimation->GetAnimationProperty().mSourceRectangles.push_back(mSRs[i]);
	}

	// Aj[V̑xݒ
	mPSprite2DAnimation->GetAnimationProperty().mSpeed = 1;
	
	// Jݒ
	mPSprite2DAnimation->SetCamera(mPCamera2D);


	// 2DJQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera2D, mPGameComponents);
}

/// 
void DebugSequenceSprite::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// ړ̑
	float kMoveSpeed = 100.0f * delta;

	// ]̑
	float kRotateSpeed = MathHelper::ToRadian(90.0f) * delta;

	// ړ
	Vector3 moveValue = Vector3::Zero();

	// ]
	Vector3 rotateValue = Vector3::Zero();


	// ShiftL[ĂȂAxグ
	if (pKB->IsDown(Keys::eKEY_RSHIFT) ||
		pKB->IsDown(Keys::eKEY_LSHIFT))
	{
		kMoveSpeed *= 5.0f;
		kRotateSpeed *= 4.0f;
	}

	// WL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_W))
	{
		moveValue -= Vector3::UnitY() * kMoveSpeed;
	}
	// SL[ĂȂ
	else if (pKB->IsDown(Keys::eKEY_S))
	{
		moveValue += Vector3::UnitY() * kMoveSpeed;
	}

	// AL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_A))
	{
		moveValue -= Vector3::UnitX() * kMoveSpeed;
	}
	else if (pKB->IsDown(Keys::eKEY_D))
	{
		moveValue += Vector3::UnitX() * kMoveSpeed;
	}

	// QL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_Q))
	{
		rotateValue -= Vector3::UnitZ() * kRotateSpeed;

	}
	// EL[ĂȂ
	else if (pKB->IsDown(Keys::eKEY_E))
	{
		rotateValue += Vector3::UnitZ() * kRotateSpeed;
	}

	// XvCgłȂ
	if (!mPSprites.empty())
	{
		// ړʂ𔽉f
		mPSprites.front()->Move(moveValue);

		// ]ʂ𔽉f
		mPSprites.front()->Rotate(rotateValue);
	}
}

/// XV
void DebugSequenceSprite::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	// C[W̍XV
	for (int i = 0; i < (int)mImages.size(); ++i)
	{
		mImages.at(i)->Update(delta);
	}

	// XvCg̍XV
	for (int i = 0; i < (int)mPSprites.size(); ++i)
	{
		mPSprites.at(i)->Update(delta);
	}
}

/// `
void DebugSequenceSprite::Render()
{
	// ̕`揈
	SequenceBase::Render();

	// C[W̕`
	SpriteBatch* pSB = SpriteBatch::GetInstance();
	pSB->Begin();
	for (int i = 0; i < (int)mImages.size(); ++i)
	{
		mImages.at(i)->Render();
	}
	pSB->End();
}