#ifndef extentionNameSQUENCE_DEBUG_DEBUGSEQUENCESOUND_H
#define extentionNameSQUENCE_DEBUG_DEBUGSEQUENCESOUND_H

#include "Blast/Base/SequenceBase.h"

namespace Sequence
{
	namespace Debug
	{
		/// ̃eXgs{V[PX
		class DebugSequenceSound : public Blast::Base::SequenceBase
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// j[Gg[
			enum EMenuEntry
			{
				/// BGM
				eMENU_ENTRY_BGM_NAME,
				
				/// SE
				eMENU_ENTRY_SE_NAME,


				/// 񋓗vf̐
				eMENUENTRY_COUNT,
			};

			
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// j[ږ
			static const TCHAR* const mStKPMenuEntryNames[eMENUENTRY_COUNT];


			
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// MEMO:WAVEtH[}bg̒`ɏ܂B
			/// PCMpWAVEtH[}bg
			struct SPCMWaveFormat
			{
			public:
				/// RXgN^
				SPCMWaveFormat(unsigned short channelCount, unsigned samplingRate, unsigned pcmDataSize)
				{
					// 
					ZeroMemory(this, sizeof(SPCMWaveFormat));

					// 萔sĐݒ
					memcpy(mRIFFHeader, "RIFF", sizeof(mRIFFHeader));
					memcpy(mWAVEHeader, "WAVE", sizeof(mWAVEHeader));
					memcpy(mFMTChankName, "fmt ", sizeof(mFMTChankName));
					mFMTChankSize = 16;
					mFormatID = 1;
					mChannelCount = channelCount;
					mSamplingRate = samplingRate;
					memcpy(mDataChankName, "data", sizeof(mDataChankName));
					mPCMDataSize = pcmDataSize;

					// MEMO:16bitŒɂ܂B
					mBitPerSample = 16;

					// MEMO:TvO[g x rbg[gTCY / 8 x `l
					mDataTransfarSpeedPerSecond = mSamplingRate * mBitPerSample / 8 * mChannelCount;

					// MEMO:rbg[gTCY / 8 x `l
					mBlockSize = mBitPerSample / 8 * mChannelCount;

					// MEMO:RIFFwb_[4oCgƁA̕ϐ̂4oCg܂݂܂B
					// t@CTCYZo
					mRIFFSize = sizeof(SPCMWaveFormat) - sizeof(mRIFFHeader) - sizeof(unsigned) + pcmDataSize;
				}


				/// RIFFwb_[
				CHAR mRIFFHeader[4];

				/// RIFFwb_[܂܂Ȃt@CTCY
				unsigned mRIFFSize;

				/// WAVEwb_[
				CHAR mWAVEHeader[4];

				/// fmt`N
				CHAR mFMTChankName[4];

				/// MEMO:PCM̏ꍇ16ŒłB
				/// fmt`NTCY
				unsigned mFMTChankSize;

				/// MEMO:PCM̏ꍇ1ŒłB
				/// tH[}bgID
				unsigned short mFormatID;

				/// `l
				unsigned short mChannelCount;

				/// TvO[g
				unsigned mSamplingRate;

				/// 1bԂ̃f[^]x
				unsigned mDataTransfarSpeedPerSecond;

				/// ubNTCYB1TṽTCY
				unsigned short mBlockSize;

				/// PTṽrbg
				unsigned short mBitPerSample;

				/// f[^`N
				CHAR mDataChankName[4];

				/// PCMf[^̃TCY
				unsigned mPCMDataSize;
			};



			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			DebugSequenceSound();

			/// fXgN^
			virtual ~DebugSequenceSound();


			/// 
			virtual void Initialize();

			/// 
			virtual void HandleInput(float delta);

			/// `
			virtual void Render();

		private:
			/// BGMQ
			std::vector<tstring> mBgmNames;

			/// SEQ
			std::vector<tstring> mSENames;



			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// DirectSoundŉ炵Ă݂鏈
			void PlayDirectSound();

			/// OggVorbisǂݍŖ炵Ă݂鏈
			void PlayOggSound();

			/// Oggt@CXg[Đ鏈
			void PlayOggStreamSound();

			/// NXgOggt@CXg[Đ鏈
			void PlayOggStreamSoundClass();

			/// NXgăɓWJOggt@CXg[Đ鏈
			void PlayOggInMemoryStreamSoundClass(const TCHAR* const, bool isLoop);
		};

	} // namespace Debug
} // namespace Sequence

#endif // extentionNameSQUENCE_DEBUG_DEBUGSEQUENCESOUND_H