#include "DebugSequenceSound.h"

#include "Blast/Audio/AudioPCMPlayerDX8.h"
#include "Blast/Audio/AudioPCMDecoder.h"
#include "Blast/Audio/AudioOggDecoder.h"
#include "Blast/Audio/AudioOggResourceFile.h"
#include "Blast/Audio/AudioOggResourceMemory.h"
#include "Blast/Input/InputManager.h"
#include "Blast/Storage/Directory.h"
#include "Blast/String/StringHelper.h"


// WAVEt@Cǂݍނ߂ɕKvȃCuAwb_p
#pragma comment ( lib, "winmm.lib" )
#include <mmsystem.h>


using namespace Sequence::Debug;
using namespace Blast::String;
using namespace Blast::Audio;
using namespace Blast::Base;
using namespace Blast::Storage;
using namespace Blast::Input;



// wTCYPCMobt@𖄂߂֐
unsigned GetPCMBuffer(OggVorbis_File* pOVFile, CHAR* pBuffer, int bufferSize, bool isLoop, bool* pOutIsEnd = 0)
{
	// obt@Ȃ
	if (pBuffer == NULL)
	{
		// ItȌo͕ϐLȂ
		if (pOutIsEnd)
		{
			*pOutIsEnd = true;
		}

		return 0;
	}


	// ItȌo͕ϐLȂ
	if (pOutIsEnd)
	{
		*pOutIsEnd = false;
	}

	// obt@
	ZeroMemory(pBuffer, bufferSize);


	int requestSize = 4096;
	int bitstream = 0;
	int readSize = 0;
	int comSize = 0;
	bool isAdjust = false;


	// obt@TCYvTCYȂ
	if (bufferSize < requestSize)
	{
		// vTCYobt@TCYɂ
		requestSize = bufferSize;

		// iKłtO𗧂Ă
		isAdjust = true;
	}


	// CAUTION:[v
	while (true)
	{
		// ǂݍ
		readSize = ov_read(pOVFile, (CHAR*)(pBuffer + comSize), requestSize, 0, 2, 1, &bitstream);

		// EOFȂ
		if (readSize == 0)
		{
			 // [vȂ
			 if (isLoop)
			 {
				// ǂݍ݈ʒuŏɖ߂
				ov_time_seek(pOVFile, 0.0);
			 }
			 // [vȂȂ
			 else
			 {
				 // ItȌo͕ϐLȂ
				 if (pOutIsEnd)
				 {
					 *pOutIsEnd = true;
				 }

				 // I
				 return comSize;
			 }
		}

		// TCYZ
		comSize += readSize;

		// TCYobt@TCY𒴂
		if (bufferSize <= comSize)
		{
			// obt@𖄂ߐŝŏI
			return comSize;
		}

		// obt@܂ĂȂȂ
		if (bufferSize - comSize < 4096)
		{
			// iK
			isAdjust = true;
			
			// vTCYcobt@̃TCYɐݒ
			requestSize = bufferSize - comSize;
		}
	}

	// ǂ킩ȂG[
	return 0;
}

//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// j[ږ
const TCHAR* const DebugSequenceSound::mStKPMenuEntryNames[] =
{
	_T("BGM"),
	_T("SE"),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceSound::DebugSequenceSound()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceSound::~DebugSequenceSound()
{
}


/// 
void DebugSequenceSound::Initialize()
{
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceSound");

	// Gg[Xg쐬
	SP<MenuEntryListScroll> pEntryList(NEW MenuEntryListScroll());
	pEntryList->GetPropertyRef().mNameStr = _T("<TEh>");
	
	// fobOj[ɒǉ
	mPDebugMenu->AddMenuEntryList(pEntryList);


	// BGMGg[쐬
	const TCHAR* const kPBgmDirectoryPath = _T("./Res/Test/Sound/BGM/");
	Directory::GetFileNamesInDirectory(kPBgmDirectoryPath, &mBgmNames);

	SP<MenuEntryStrings> pBgmNamesEntry(NEW MenuEntryStrings());
	pBgmNamesEntry->SetText(mStKPMenuEntryNames[eMENU_ENTRY_BGM_NAME]);
	for (unsigned i = 0; i < mBgmNames.size(); ++i)
	{
		tstring bgmNameStr = kPBgmDirectoryPath;
		bgmNameStr += mBgmNames.at(i).c_str();

		pBgmNamesEntry->AddString(bgmNameStr.c_str());
	}

	pEntryList->AddMenuEntry(pBgmNamesEntry);


	// SEGg[쐬
	const TCHAR* const kPSeDirectoryPath = _T("./Res/Test/Sound/SE/");
	Directory::GetFileNamesInDirectory(kPSeDirectoryPath, &mSENames);

	SP<MenuEntryStrings> pSeNamesEntry(NEW MenuEntryStrings());
	pSeNamesEntry->SetText(mStKPMenuEntryNames[eMENU_ENTRY_SE_NAME]);
	for (unsigned i = 0; i < mSENames.size(); ++i)
	{
		tstring seNameStr = kPSeDirectoryPath;
		seNameStr += mSENames.at(i).c_str();

		pSeNamesEntry->AddString(seNameStr.c_str());
	}

	pEntryList->AddMenuEntry(pSeNamesEntry);
}

/// 
void DebugSequenceSound::HandleInput(float delta)
{
	// L[{[h擾
	IKeyboard* pKB = InputManager::GetInstance()->GetKeyboard();
	if (pKB)
	{
		// EnterL[
		if (pKB->IsJustDown(Keys::eKEY_RETURN))
		{
			// IĂ郁j[Gg[擾
			SP<IMenuEntryList> pSelectedEntryList = mPDebugMenu->GetSelectedMenuEntryList();
			if (pSelectedEntryList)
			{
				// I𒆂̃Gg[擾
				SP<IMenuEntry> pSelectedEntry = pSelectedEntryList->GetSelectedMenuEntry();
				if (pSelectedEntry)
				{
					// TEh
					tstring soundName;


					// I𒆂̃Gg[CfbNX擾
					const int kSelectedEntryIndex = pSelectedEntryList->GetSelectedIndex();
					switch (kSelectedEntryIndex)
					{
						case eMENU_ENTRY_BGM_NAME:
						case eMENU_ENTRY_SE_NAME:
						{
							SP<MenuEntryStrings> pEntryStrings;
							pEntryStrings.DownCast(pSelectedEntry);
							if (pEntryStrings)
							{
								soundName = pEntryStrings->GetSelectedString();
							}
						}
							break;

						default:
							break;
					}


					// gq擾
					TCHAR extentionName[Directory::mStKMaxExtention];
					Directory::GetExtention(soundName.c_str(), extentionName);

					// gqwavȂ
					if (_tcsicmp(extentionName, _T(".wav")) == 0)
					{
						// DirectSoundŉ炷
						PlayDirectSound();
					}
					// gq.oggȂ
					else if (_tcsicmp(extentionName, _T(".ogg")) == 0)
					{
						//// OggVorbisŉ炷
						//PlayOggSound();

						//// Oggt@CXg[Đ
						//PlayOggStreamSound();

						///// NXgOggt@CXg[Đ
						//PlayOggStreamSoundClass();

						/// NXgăɓWJOggt@CXg[Đ鏈
						PlayOggInMemoryStreamSoundClass(soundName.c_str(), false);
					}
				}
			}
		}
	}




	// ̏Ă
	SequenceBase::HandleInput(delta);
}

/// `
void DebugSequenceSound::Render()
{
	// ̏Ă
	SequenceBase::Render();


	DP(10, 500, 0xffffffff, _T("ڂIEnterL[ƁAĐJn܂B"));
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// DirectSoundŉ炵Ă݂鏈
void DebugSequenceSound::PlayDirectSound()
{
	// DirectSound쐬
	CSP<IDirectSound8> pDS8;
	HRESULT hr = DirectSoundCreate8(NULL, pDS8.ToCreator(), NULL);

	// ASSERT:DirectSound̍쐬ɎsȂ玀
	ASSERT_PF(SUCCEEDED(hr), _T("IDirectSound8̍쐬Ɏs܂B"));


	// [hݒ
	HWND hWnd = FindWindow(NULL, _T("Hallucinogen"));
	pDS8->SetCooperativeLevel(hWnd, DSSCL_NORMAL);


	// Wavet@CI[v
	HMMIO hMmio = NULL;
	MMIOINFO mmioInfo;

	ZeroMemory(&mmioInfo, sizeof(MMIOINFO));
	hMmio = mmioOpen(_T("./Res/Test/Sound/SE/tm2_slash000.wav"), &mmioInfo, MMIO_READ);

	// HALT:t@C̓WJɎsȂ玀B
	if (!hMmio)
	{
		HALT(_T("t@C̓WJɎs܂B"));
	}
	// t@C̓WJɐȂ
	else
	{
		// HALT:G[oĂȂ玀B
		switch (mmioInfo.wErrorRet)
		{
			case MMIOERR_ACCESSDENIED:	HALT(_T("t@C͕ی삳ĂĊJ܂B"));	break;
			case MMIOERR_INVALIDFILE:	HALT(_T("ʂ̏Q܂B̓t@C̃I[vɊւQ̊G[łB"));	break;
			case MMIOERR_NETWORKERROR:	HALT(_T("lbg[N[gt@C̃I[vvɉ܂B"));	break;
			case MMIOERR_PATHNOTFOUND:	HALT(_T("fBNg̎dlsłB"));	break;
			case MMIOERR_SHARINGVIOLATION:	HALT(_T("t@Cق̃AvP[VŎgp̂߁Apł܂B"));	break;
			case MMIOERR_TOOMANYOPENFILES:	HALT(_T("ɊJt@Cő僌xɒB܂BVXepłt@Cnh܂B"));	break;
			default:	break;
		}
	}


	// RIFF`N
	MMRESULT mmRes;
	MMCKINFO riffChunk;
	riffChunk.fccType = mmioFOURCC('W', 'A', 'V', 'E');
	mmRes = mmioDescend(hMmio, &riffChunk, NULL, MMIO_FINDRIFF);
	if (mmRes != MMSYSERR_NOERROR)
	{
		mmioClose(hMmio, 0);

		HALT(_T("RIFF`ŇɎs܂B"));
	}

	// tH[}bg`N
	MMCKINFO formatChunk;
	formatChunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
	mmRes = mmioDescend(hMmio, &formatChunk, &riffChunk, MMIO_FINDCHUNK);
	if (mmRes != MMSYSERR_NOERROR)
	{
		mmioClose( hMmio, 0 );

		HALT(_T("tH[}bg`ŇɎs܂B"));
	}

	// WAVE擾
	WAVEFORMATEX sWaveFormat;
	DWORD fmsize = formatChunk.cksize;
	DWORD size = mmioRead(hMmio, (HPSTR)&sWaveFormat, fmsize);
	if (size != fmsize)
	{
		mmioClose(hMmio, 0);

		HALT(_T("WAVE擾Ɏs܂B"));
	}


	// MEMO:̃f[^`N͓KwȂ̂ŁAł悤Ɉ߂܂B
	// `N߂
	mmioAscend(hMmio, &formatChunk, 0);


	// f[^`N
	MMCKINFO dataChunk;
	dataChunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
	mmRes = mmioDescend(hMmio, &dataChunk, &riffChunk, MMIO_FINDCHUNK);
	if (mmRes != MMSYSERR_NOERROR)
	{
		mmioClose(hMmio, 0);

		HALT(_T("f[^`N̎擾Ɏs܂B"));
	}

	// f[^擾
	CHAR* pWaveData = new CHAR[dataChunk.cksize];
	size = mmioRead(hMmio, (HPSTR)pWaveData, dataChunk.cksize);
	if (size != dataChunk.cksize)
	{
		SAFE_DELETE_ARRAY(pWaveData);
		mmioClose(hMmio, 0);

		HALT(_T("f[^̎擾Ɏs܂B"));
	}


	// MMIO
	mmioClose(hMmio, 0);


	// ZJ_obt@쐬
	DSBUFFERDESC sDSBufferDesc;
	sDSBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	sDSBufferDesc.dwFlags = 0;
	sDSBufferDesc.dwBufferBytes = size;
	sDSBufferDesc.dwReserved = 0;
	sDSBufferDesc.lpwfxFormat = &sWaveFormat;
	sDSBufferDesc.guid3DAlgorithm = GUID_NULL;

	CSP<IDirectSoundBuffer> pDSBuffer;
	hr = pDS8->CreateSoundBuffer(&sDSBufferDesc, pDSBuffer.ToCreator(), NULL);

	// ASSERT:ZJ_obt@̍쐬ɎsȂ玀
	ASSERT_PF(SUCCEEDED(hr), _T("ZJ_obt@̍쐬Ɏs܂B"));


	// obt@LXg
	CSP<IDirectSoundBuffer8> pDSBuffer8;
	pDSBuffer->QueryInterface(IID_IDirectSoundBuffer8, (LPVOID*)pDSBuffer8.GetInterfacePtr());

	// ASSERT:LXgɎsȂ玀B
	ASSERT_PF(pDSBuffer8, _T("IDirectSoundBuffer8ւ̃LXgɎs܂B"));


	// ZJ_obt@WAVEf[^
	LPVOID pWrite = NULL;
	DWORD length = 0;

	hr = pDSBuffer->Lock(0, 0, &pWrite, &length, NULL, NULL, DSBLOCK_ENTIREBUFFER);
	ASSERT_PF(SUCCEEDED(hr), _T("ZJ_obt@ւWAVEf[^݂̏Ɏs܂B"));
	{
		memcpy(pWrite, pWaveData, length);
	}
	pDSBuffer->Unlock(pWrite, length, NULL, 0);


	// Đ
	pDSBuffer->Play(0, 0, 0);


	// 1b҂
	Sleep(1000);


	// ~
	pDSBuffer->Stop();
}


/// OggVorbisǂݍŖ炵Ă݂鏈
void DebugSequenceSound::PlayOggSound()
{
	// MEMO:ChɔΉȂ̂ŁAMBCSŎw肵܂B
	// Oggt@Cǂݍ
	OggVorbis_File ovFile;
	//const int kErrorCode = ov_fopen("./Res/Test/Sound/SE/̃V@SPIVI_LvUpME.ogg", &ovFile);
	const int kErrorCode = ov_fopen("./Res/Test/Sound/BGM/13 - Waltz for Ariah (short version).ogg", &ovFile);

	// ǂݍ݂ɎsȂ
	if (kErrorCode != 0)
	{
		// G[R[hŕ
		switch (kErrorCode)
		{
			// fBA̓ǂݎG[
			case OV_EREAD:
				HALT(_T("Ogg`̃fBA̓ǂݎɎs܂B"));
				break;

			// rbgXg[Vorbis̃f[^܂܂ĂȂ
			case OV_ENOTVORBIS:
				HALT(_T("rbgXg[Vorbisf[^܂܂Ă܂B"));
				break;

			// Vorbis̃o[W̕sv
			case OV_EVERSION:
			{
				TCHAR wVorbisVersion[StringHelper::mStKDefaultBufferSize];
				StringHelper::ToWideChar(wVorbisVersion, sizeof(TCHAR) * StringHelper::mStKDefaultBufferSize, vorbis_version_string());

				HALT(_T("Vorbis̃o[WvĂ܂B\nVorbiso[W=%s"), wVorbisVersion);

				break;
			}

			// Vorbis̃rbgXg[̃wb_
			case OV_EBADHEADER:
				HALT(_T("Vorbis̃rbgXg[̃wb_łB"));
				break;

			// WbN̏QAoOq[v^X^bN̔j
			case OV_EFAULT:
				HALT(_T("WbN̏QAoOq[v/X^bN̔jĂ܂B"));
				break;

			default:
				break;
		}
	}


	// 擾
	vorbis_info* pVorbisInfo = ov_info(&ovFile, -1);

	// ASSERT:̎擾ɎsȂ玀B
	ASSERT_PF(pVorbisInfo, _T("Oggt@C̏̎擾Ɏs܂B"));


	// ǂݎɕKvȕϐp
	const int kBufferSize = 1024 * 10000;	// MEMO:10MB
	SP<CHAR> pBuffer(NEW CHAR[kBufferSize], true);	// ǂݍ݌ʂ̑obt@
	SP<CHAR> pTempBuffer(NEW CHAR[kBufferSize], true);	// 1񕪂̓ǂݍ݃obt@
	const int kBigEndian = 0;	// rbOGfBAǂBWindows̓gGfBAȂ̂0
	const int kWordByteSize = 2;	// WORD^̃TCY
	const int kSign = 1;	// PCM̗̕LBʏ필tȂ̂1
	int bitStream = 0;	// Xg[Đ̈ʒu
	int comSize = 0;	// obt@̍vTCY

	// MEMO:Oggt@C͈ꊇœǂݍނƂłȂ߁ASēǂݍނ܂Ń[v܂B
	// CAUTION:[v
	while (true)
	{
		// ǂݍ
		const unsigned kReadSize = ov_read(&ovFile, pTempBuffer.GetSource(), kBufferSize, kBigEndian, kWordByteSize, kSign, &bitStream);

		// obt@I[o[邩Aǂݍ݂IȂ
		if (kBufferSize < comSize + kReadSize || kReadSize == 0)
		{
			break;
		}

		// ꎞobt@Rs[
		memcpy(pBuffer.GetSource() + comSize, pTempBuffer.GetSource(), kReadSize);

		// TCYZ
		comSize += kReadSize;
	}

	// PCMpWAVEݒ
	SPCMWaveFormat sPCMWave(pVorbisInfo->channels, pVorbisInfo->rate, comSize);

	// PCM̃f[^ݒ
	const unsigned kPCMImageSize = sizeof(SPCMWaveFormat) + comSize;
	SP<CHAR> pPCMImage(NEW CHAR[kPCMImageSize], true);

	memcpy(pPCMImage.GetSource(), &sPCMWave, sizeof(SPCMWaveFormat));
	memcpy(pPCMImage.GetSource() + sizeof(SPCMWaveFormat), pBuffer.GetSource(), comSize);


	// Đ
	BOOL res = PlaySound((LPCWSTR)pPCMImage.GetSource(), NULL, SND_ASYNC | SND_MEMORY);

	// WARNING:ĐɎsȂxB
	WARNING(SUCCEEDED(res), _T("̍ĐɎs܂B"));


	// Oggt@C
	ov_clear(&ovFile);


	// 3bԑ҂
	Sleep(3000);


	// ~
	PlaySound(NULL, NULL, 0);
}

/// Oggt@CXg[Đ鏈
void DebugSequenceSound::PlayOggStreamSound()
{
	// DirectSound쐬
	CSP<IDirectSound8> pDS8;
	HRESULT hr = DirectSoundCreate8(NULL, pDS8.ToCreator(), NULL);

	// ASSERT:DirectSound̍쐬ɎsȂ玀
	ASSERT_PF(SUCCEEDED(hr), _T("IDirectSound8̍쐬Ɏs܂B"));


	// [hݒ
	HWND hWnd = FindWindow(NULL, _T("Hallucinogen"));
	pDS8->SetCooperativeLevel(hWnd, DSSCL_NORMAL);


	// ZJ_obt@쐬
	int playTime = 1; // 1b


	// Oggt@CWJ
	OggVorbis_File ovFile;
	const int kErrorCode = ov_fopen("./Res/Test/Sound/BGM/13 - Waltz for Ariah (short version).ogg", &ovFile);
	if (kErrorCode != 0)
	{
		return;
	}
	

	// Oggt@C̏擾
	vorbis_info *pInfo = ov_info(&ovFile, -1);


	// WAVE
	WAVEFORMATEX waveFormat;
	waveFormat.wFormatTag = WAVE_FORMAT_PCM;
	waveFormat.nChannels = pInfo->channels;
	waveFormat.nSamplesPerSec = 44100;
	waveFormat.wBitsPerSample = 16;
	waveFormat.nBlockAlign = pInfo->channels * 16 / 8;
	waveFormat.nAvgBytesPerSec = waveFormat.nSamplesPerSec * waveFormat.nBlockAlign;
	waveFormat.cbSize = 0;

	// DirectSoundBuffer
	DSBUFFERDESC DSBufferDesc;
	DSBufferDesc.dwSize = sizeof(DSBUFFERDESC);
	DSBufferDesc.dwFlags = DSBCAPS_GLOBALFOCUS;	// ANeBułꑱ悤ɐݒ
	DSBufferDesc.dwBufferBytes = waveFormat.nAvgBytesPerSec * playTime;
	DSBufferDesc.dwReserved = 0;
	DSBufferDesc.lpwfxFormat = &waveFormat;
	DSBufferDesc.guid3DAlgorithm = GUID_NULL;

	// ZJ_obt@쐬
	CSP<IDirectSoundBuffer> ptmpBuf;
	CSP<IDirectSoundBuffer8> pDSBuffer;
	if (SUCCEEDED(pDS8->CreateSoundBuffer(&DSBufferDesc, ptmpBuf.ToCreator(), NULL)))
	{
		ptmpBuf->QueryInterface(IID_IDirectSoundBuffer8 , (LPVOID*)pDSBuffer.ToCreator());
	}


	// f[^
	void* AP1 = 0, *AP2 = 0;
	DWORD AB1 = 0, AB2 = 0;
	if (SUCCEEDED(pDSBuffer->Lock( 0, 0, &AP1, &AB1, &AP2, &AB2, DSBLOCK_ENTIREBUFFER)))
	{
		// bNobt@ɏPCMf[^
		GetPCMBuffer(&ovFile, (CHAR*)AP1, AB1, false);

		// AbN
		pDSBuffer->Unlock(AP1, AB1, AP2, AB2);
	}


	// Đ
	pDSBuffer->Play(0, 0, DSBPLAY_LOOPING);


	// XCb`O
	unsigned int size = DSBufferDesc.dwBufferBytes / 2;
	unsigned int flag = 0;
	DWORD point = 0;

	// CAUTION:[v
	while (true)
	{
		// 0.016b҂
		Sleep(16);

		pDSBuffer->GetCurrentPosition(&point, 0 );
		if ( flag == 0 && point >= size )
		{
			// Oɏ
			if ( SUCCEEDED( pDSBuffer->Lock( 0, size, &AP1, &AB1, &AP2, &AB2, 0 ) ) )
			{
				GetPCMBuffer( &ovFile, (CHAR*)AP1, AB1, true );
				pDSBuffer->Unlock( AP1, AB1, AP2, AB2 );
				flag = 1;

				PFL(_T("Oɏ݁Bpoint=%u, AP1=0x%x, AB1=%u, AP2=0x%x, AB2=%u"), point, AP1, AB1, AP2, AB2);
			}
		}
		else if ( flag == 1 && point < size )
		{
			// 㔼ɏ
			if ( SUCCEEDED( pDSBuffer->Lock( size, size * 2, &AP1, &AB1, &AP2, &AB2, 0 ) ) )
			{
				GetPCMBuffer( &ovFile, (CHAR*)AP1, AB1, true );
				pDSBuffer->Unlock( AP1, AB1, AP2, AB2 );
				flag = 0;

				PFL(_T("㔼ɏ݁Bpoint=%u, AP1=0x%x, AB1=%u, AP2=0x%x, AB2=%u"), point, AP1, AB1, AP2, AB2);
			}
		}

		// EscapeL[甲
		if ( GetAsyncKeyState( VK_RETURN ) )
		{
			break;
		}
	}


	// t@C
	ov_clear(&ovFile);

	// ~
	pDSBuffer->Stop();
}

/// NXgOggt@CXg[Đ鏈
void DebugSequenceSound::PlayOggStreamSoundClass()
{
	// DirectSound쐬
	CSP<IDirectSound8> pDS8;
	HRESULT hr = DirectSoundCreate8(NULL, pDS8.ToCreator(), NULL);

	// ASSERT:DirectSound̍쐬ɎsȂ玀
	ASSERT_PF(SUCCEEDED(hr), _T("IDirectSound8̍쐬Ɏs܂B"));


	// [hݒ
	HWND hWnd = FindWindow(NULL, _T("Hallucinogen"));
	pDS8->SetCooperativeLevel(hWnd, DSSCL_NORMAL);


	// OggIuWFNg쐬
	SP<AudioOggResourceFile> pResource(NEW AudioOggResourceFile());
	pResource->Load(_T("./Res/Test/Sound/BGM/13 - Waltz for Ariah (short version).ogg"));

	SP<AudioOggDecoder> pOggDecoder(NEW AudioOggDecoder());
	pOggDecoder->SetAudioResource(pResource);

	SP<AudioPCMPlayerDX8> pOggPlayer(NEW AudioPCMPlayerDX8(pDS8, pOggDecoder));
	pOggPlayer->SetVolume(-1500);

	if (!pOggPlayer->Play( true ))
	{
		PFL(_T("t@CɎsĂ܂"));
	}


	// CAUTION:[v
	while (true)
	{
		// EnterL[甲
		if ( GetAsyncKeyState( VK_RETURN ) )
		{
			break;
		}
	}
}

/// NXgăɓWJOggt@CXg[Đ鏈
void DebugSequenceSound::PlayOggInMemoryStreamSoundClass(const TCHAR* const kPFileName, bool isLoop)
{
	// DirectSound쐬
	CSP<IDirectSound8> pDS8;
	HRESULT hr = DirectSoundCreate8(NULL, pDS8.ToCreator(), NULL);

	// ASSERT:DirectSound̍쐬ɎsȂ玀
	ASSERT_PF(SUCCEEDED(hr), _T("IDirectSound8̍쐬Ɏs܂B"));


	// [hݒ
	HWND hWnd = FindWindow(NULL, _T("Hallucinogen"));
	pDS8->SetCooperativeLevel(hWnd, DSSCL_NORMAL);


	// OggIuWFNg쐬
	SP<AudioOggResourceMemory> pResource(NEW AudioOggResourceMemory());
	pResource->Load(kPFileName);

	SP<AudioOggDecoder> pOggDecoder(NEW AudioOggDecoder());
	pOggDecoder->SetAudioResource(pResource);
	
	const int kPlayerCount = 1;
	SP<AudioPCMPlayerDX8> pOggPlayers(NEW AudioPCMPlayerDX8[kPlayerCount], true);
	for (int i = 0; i < kPlayerCount; ++i)
	{
		pOggPlayers[i].SetDevice(pDS8);
		pOggPlayers[i].SetDecoder(pOggDecoder);
		pOggPlayers[i].SetVolume(-1500);
	}

	if (!pOggPlayers[0].Play(isLoop))
	{
		PFL(_T("t@CɎsĂ܂"));
	}


	// CAUTION:[v
	while (true)
	{
		// EnterL[甲
		if (GetAsyncKeyState(VK_RETURN))
		{
			break;
		}

		// CtrlL[ڂ炷
		if (GetAsyncKeyState(VK_CONTROL))
		{
			pOggPlayers[1].Play(isLoop);
		}
	}
}