#include "Sequence/Debug/DebugSequencePrimitive.h"

#include "Blast/Graphic/DirectX/MeshBoxDX.h"
#include "Blast/Graphic/DirectX/MeshSphereDX.h"
#include "Blast/Graphic/DirectX/MeshCylinderDX.h"
#include "Blast/Graphic/DirectX/MeshTorusDX.h"
#include "Blast/Graphic/DirectX/MeshTeapotDX.h"
#include "Blast/Graphic/DirectX9/MeshPlaneDX9.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequencePrimitive::DebugSequencePrimitive()
	: SequenceBase(false)
{
	// J쐬
	mPCamera.SetPointer(NEW Camera3DOperation());
	mPCamera->SetPosition(Vector3(50.0f, 50.0f, -50.0f));


	// v~eBu{bNX쐬
	SP<MeshBoxDX> pMeshBoxDX(NEW MeshBoxDX());
	pMeshBoxDX->CreateMesh(10.0f, 10.0f, 10.0f);

	SP<PrimitiveModelDX9> pPrimBox(NEW PrimitiveModelDX9());
	pPrimBox->SetMesh(pMeshBoxDX);
	pPrimBox->SetCamera(mPCamera);
	pPrimBox->SetPosition(Vector3(15.0f, 0.0f, 15.0f));

	mPrimModels.push_back(pPrimBox);


	// v~eBuXtBA쐬
	SP<MeshSphereDX> pMeshSphereDX(NEW MeshSphereDX());
	pMeshSphereDX->CreateMesh(5.0f, 12, 12);

	SP<PrimitiveModelDX9> pPrimSphere(NEW PrimitiveModelDX9());
	pPrimSphere->SetMesh(pMeshSphereDX);
	pPrimSphere->SetCamera(mPCamera);
	pPrimSphere->SetColor(0xffff8844);
	pPrimSphere->SetPosition(Vector3(15.0f, 0.0f, 0.0f));

	mPrimModels.push_back(pPrimSphere);


	// v~eBuV_[쐬
	SP<MeshCylinderDX> pMeshCylinderDX(NEW MeshCylinderDX());
	pMeshCylinderDX->CreateMesh(5.0f, 5.0f, 5.0f, 12, 12);

	SP<PrimitiveModelDX9> pPrimCylinder(NEW PrimitiveModelDX9());
	pPrimCylinder->SetMesh(pMeshCylinderDX);
	pPrimCylinder->SetCamera(mPCamera);
	pPrimCylinder->SetPosition(Vector3(-15.0f, 0.0f, 0.0f));

	mPrimModels.push_back(pPrimCylinder);


	// v~eBug[X쐬
	SP<MeshTorusDX> pMeshTorusDX(NEW MeshTorusDX());
	pMeshTorusDX->CreateMesh(1.0f, 5.0f, 12, 24);

	SP<PrimitiveModelDX9> pPrimTorus(NEW PrimitiveModelDX9());
	pPrimTorus->SetMesh(pMeshTorusDX);
	pPrimTorus->SetCamera(mPCamera);
	pPrimTorus->SetPosition(Vector3(0, 0, 20.0f));

	mPrimModels.push_back(pPrimTorus);


	// v~eBueB[|bg쐬
	SP<MeshTeapotDX> pMeshTeapotDX(NEW MeshTeapotDX());
	pMeshTeapotDX->CreateMesh();

	SP<PrimitiveModelDX9> pPrimTeapot(NEW PrimitiveModelDX9());
	pPrimTeapot->SetMesh(pMeshTeapotDX);
	pPrimTeapot->SetCamera(mPCamera);	
	pPrimTeapot->SetPosition(Vector3(-20.0f, 0, 20.0f));
	pPrimTeapot->SetScale(Vector3(5.0f, 5.0f, 5.0f));

	mPrimModels.push_back(pPrimTeapot);


	// v~eBuv[쐬
	SP<MeshPlaneDX9> pMeshPlaneDX9(NEW MeshPlaneDX9());
	pMeshPlaneDX9->CreateMesh(30, 15, 5, 10);
	
	SP<PrimitiveModelDX9> pPrimPlane(NEW PrimitiveModelDX9());
	pPrimPlane->SetMesh(pMeshPlaneDX9);
	pPrimPlane->SetCamera(mPCamera);
	pPrimPlane->SetPosition(Vector3::Zero());

	mPrimModels.push_back(pPrimPlane);


	// XYZ쐬
	mPXYZAxis.SetPointer(NEW XYZAxisDX9());
	mPXYZAxis->SetCamera(mPCamera);
}

/// fXgN^
DebugSequencePrimitive::~DebugSequencePrimitive()
{
}


/// 
void DebugSequencePrimitive::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequencePrimitive>");


	// Gg[Xg쐬AfobOj[ɒǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<Primitive>");

	mPDebugMenu->AddMenuEntryList(pMEL);
}

/// 
void DebugSequencePrimitive::HandleInput(float delta)
{
	// J̓͏
	mPCamera->HandleInput(delta);	
}

/// XV
void DebugSequencePrimitive::Update(float delta)
{
	// XYZXV
	mPXYZAxis->Update(delta);

	// JXV
	mPCamera->Update(delta);

	// ]lp
	float rotX = MathHelper::ToRadian(0.0f) * delta;
	float rotY = MathHelper::ToRadian(45.0f) * delta;
	float rotZ = MathHelper::ToRadian(90.0f) * delta;

	// v~eBufQXV
	for (unsigned i = 0; i < mPrimModels.size(); ++i)
	{
		// ]
		mPrimModels.at(i)->Rotate(Vector3(rotX, rotY, rotZ));

		// XV
		mPrimModels.at(i)->Update(delta);
	}


	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequencePrimitive::Render()
{
	// XYZ`
	mPXYZAxis->Render();

	// v~eBufQŃ[v
	for (unsigned i = 0; i < mPrimModels.size(); ++i)
	{
		// `
		mPrimModels.at(i)->Render();
	}


	// ̕`揈
	SequenceBase::Render();
}