#include "DebugSequencePossession.h"

#include "Possession.h"
#include "ItemDatabase.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Math;


//===================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// ǉ铹ID
	int nItemIDForAdd = 0;
}


//===================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequencePossession::DebugSequencePossession(bool isPopup)
	: SequenceBase(isPopup)
{
	ItemDatabase* pIDB = ItemDatabase::GetInstance();

	// fobOj[쐬
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequencePossession");

	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<j[>");
	mPDebugMenu->AddMenuEntryList(pMEL);

	// l
	SP<MenuEntryStrings> pMES(NEW MenuEntryStrings());
	pMES->SetName(_T("l"));
	pMES->SetText(pMES->GetName());
	for (int i = 0; i < pIDB->GetCatalogCount(); ++i)
	{
		const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt(i);
		pMES->AddString(kPCatalog->mName);
	}
	pMEL->AddMenuEntry(pMES);

	// _10l
	SP<MenuEntry> pMERandomObtainTen(NEW MenuEntry());
	pMERandomObtainTen->SetName(_T("_10l"));
	pMERandomObtainTen->SetText(pMERandomObtainTen->GetName());

	pMEL->AddMenuEntry(pMERandomObtainTen);
}

/// fXgN^
DebugSequencePossession::~DebugSequencePossession()
{
}


/// 
void DebugSequencePossession::Initialize()
{
	SequenceBase::Initialize();
}

/// I
void DebugSequencePossession::Finalize()
{
	SequenceBase::Finalize();
}

/// 
void DebugSequencePossession::HandleInput(float delta)
{
	SequenceBase::HandleInput(delta);

	// 肵AGg̏s
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<MenuEntryListScroll> pMEL;
		pMEL.DownCast(mPDebugMenu->GetSelectedMenuEntryList());
		if (pMEL)
		{
			SP<IMenuEntry> pME = pMEL->GetSelectedMenuEntry();
			if (pME)
			{
				// l
				if (pME == pMEL->GetMenuEntry(_T("l")))
				{
					SP<MenuEntryStrings> pMES;
					pMES.DownCast(pME);

					ItemDatabase* pIDB = ItemDatabase::GetInstance();
					for (int i = 0; i < pIDB->GetCatalogCount(); ++i)
					{
						const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt(i);
						if (_tcscmp(kPCatalog->mName, pMES->GetSelectedString()) == 0)
						{
							Possession::GetInstance()->Obtain(kPCatalog->mID);
							PFL(_T("u%svǉB"), pMES->GetSelectedString());
						}
					}
				}
				// _10l
				else if ( pME == pMEL->GetMenuEntry(_T("_10l")) )
				{
					Random random;
					ItemDatabase* pIDB = ItemDatabase::GetInstance();
					const int kTen = 10;
					for (int i = 0; i < kTen; ++i)
					{
						const int kRandomID = random.GetNext(0, pIDB->GetCatalogCount());
						Possession::GetInstance()->Obtain(kRandomID);
					}
				}
			}
		}
	}
}

/// XV
void DebugSequencePossession::Update(float delta)
{
	SequenceBase::Update(delta);
}

/// `
void DebugSequencePossession::Render()
{
	SequenceBase::Render();
}