#include "Sequence/Debug/DebugSequenceModelViewer.h"

#include "Camera3DOperation.h"
#include "CharacterDatabase.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceModelViewer::DebugSequenceModelViewer()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceModelViewer::~DebugSequenceModelViewer()
{
}


/// 
void DebugSequenceModelViewer::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// J
	Camera3DOperation* pCamera3D = NEW Camera3DOperation();
	mPCamera.SetPointer(pCamera3D);

	pCamera3D->SetPosition(Vector3(1, 1, -1) * 2000.0f);


	// XYZ
	mPXYZAxis.SetPointer(NEW XYZAxisDX9());
	mPGameComponents->Add(mPXYZAxis);

	mPXYZAxis->SetCamera(mPCamera);
	mPXYZAxis->SetLength(2000.0f);


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceModelViewer>");

	// f̃Xgǉ
	SP<MenuEntryListMatrix> pMEL(NEW MenuEntryListMatrix());
	pMEL->SetName(_T("LN^[f"));
	pMEL->SetPosition(Vector3(10, 30, 0));
	mPDebugMenu->AddMenuEntryList(pMEL);
	
	CharacterDatabase* pCharaDB = CharacterDatabase::GetInstance();
	const std::list< SP<CharacterDatabase::SConsititution> >* pCharaConsDatas = pCharaDB->GetConsititutionDatas();
	std::list< SP<CharacterDatabase::SConsititution> >::const_iterator kIt;
	for (kIt = pCharaConsDatas->begin(); kIt != pCharaConsDatas->end(); ++kIt)
	{
		SP<MenuEntry> pME(NEW MenuEntry());
		pME->SetText((*kIt)->mDisplayName);
		pME->SetName((*kIt)->mDisplayName);

		pMEL->AddMenuEntry(pME);
	}
}

/// 
void DebugSequenceModelViewer::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);

	// J̓͏
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->HandleInput(delta);
	}


	// LN^[肵Ãfǂݍŕ\
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();
		if (pMEL)
		{
			const int kSelectedIndex = pMEL->GetSelectedIndex();

			// LN^[쐬
			mPCharacter = CharacterFactory::CreateCharacter(kSelectedIndex, Character::eCHARACTER_PLAYER);
			if (mPCharacter)
			{
				mPCharacter->SetCamera(mPCamera);
			}
		}
	}
}

/// XV
void DebugSequenceModelViewer::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	// JXV
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->Update(delta);
	}

	// LN^[XV
	if (mPCharacter)
	{
		mPCharacter->Update(delta);
	}
}

/// `
void DebugSequenceModelViewer::Render()
{
	// ̕`揈
	SequenceBase::Render();

	// LN^[`
	if (mPCharacter)
	{
		mPCharacter->Render();
	}
}