#include "Sequence/Debug/DebugSequenceMesh.h"

#include "Blast/Storage/Directory.h"
#include "Blast/String/StringHelper.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::Storage;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// Aj[Vԍ
	int nAniamtionNumber = 0;
}


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// t@C
const TCHAR* const DebugSequenceMesh::mStKPFileFullPaths[] =
{
	// XLAj[Vp̃Tv
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample2.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample3.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample4.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample5_Z-Up.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample6_Biped.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample6_Bone.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample7.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample7_Anim001.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample7_Anim002.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample8.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample8_Anim001.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample8_Anim001_TM/SkinSample8_Anim001_Take 001.FBX"),
	_T("./Res/Test/Model/SkinSample/Fbx/SkinSample8_Anim002.FBX"),


	// J
	_T("./Res/Test/Model/Kirisame Marisa/Obj/Marisa_TriangleOnly.obj"),
	_T("./Res/Test/Model/Kirisame Marisa/Fbx/Kirisame Mrisa_SkinAnimation_001.fbx"),
	_T("./Res/Test/Model/Kirisame Marisa/Fbx/Kirisame Mrisa_SkinAnimation_002.fbx"),


	// ClipũTvf
	_T("./Res/Test/Model/Clip/X/Char_Base01_TriOnly.x"),
	_T("./Res/Test/Model/Clip/X/021_Final_TriOnly.x"),

	_T("./Res/Test/Model/Clip/Obj/Char_Base01_TriOnly.obj"),
	_T("./Res/Test/Model/Clip/Obj/021_Final_TriOnly.obj"),


	// ʘA
	_T("./Res/Test/Model/Daituren/Obj/daituken.obj"),


	// ^C
	_T("./Res/Test/Model/Ground/X/Ground.x"),

	_T("./Res/Test/Model/Ground/Obj/Ground_TriangleOnly.obj"),

	_T("./Res/Test/Model/Ground/Fbx/Ground.fbx"),


	// LN^[̃bNAbv
	_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa.FBX"),
	_T("./Res/Model/Characters/99_Celsius/Celsius.FBX"),
	_T("./Res/Model/Characters/99_Mockup/Character_SD_Mockup.FBX"),
	_T("./Res/Model/Characters/99_Mockup_Dice/Character_SD_Mockup_Dice.FBX"),
};

/// t@C̐
const int DebugSequenceMesh::mStKFileFullPathCount = sizeof(mStKPFileFullPaths) / sizeof(mStKPFileFullPaths[0]);


/// eNjbN
const CHAR* const DebugSequenceMesh::mStKTechniqueNames[] =
{
	ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_WIREFRAME_ONLY),
	ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT),
	ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_LAMBERT),
	ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_PHONG),
};

/// eNjbN̐
const int DebugSequenceMesh::mStKTechniqueNameCount = sizeof(mStKTechniqueNames) / sizeof(mStKTechniqueNames[0]);


/// Aj[Vt@CpXQ
const TCHAR* const DebugSequenceMesh::stKPAnimationFilePaths[] =
{
	_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Stand_Take 001.fbx"),
	_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa_Anim_Walk_Take 001.fbx"),
	_T("./Res/Model/Characters/99_Celsius/Celsius_Biped_Anim_Stand_Take 001.fbx"),
	_T("./Res/Model/Characters/99_Mockup_Dice/Character_SD_Mockup_Dice_002_Anim_Roll_Take 001.fbx"),
};

/// Aj[Vt@CpX̐
const int DebugSequenceMesh::stKAnimationFilePathCount = sizeof(stKPAnimationFilePaths) / sizeof(stKPAnimationFilePaths[0]);


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceMesh::DebugSequenceMesh()
	: SequenceBase(false)
	, mPCamera(NEW Camera3DOperation())
	, mPModel(NEW BtModelDX9())
{
}

/// fXgN^
DebugSequenceMesh::~DebugSequenceMesh()
{
}


/// 
void DebugSequenceMesh::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// JZbgAbv
	mPCamera->SetLookAt(Vector3::UnitY() * 500);
	mPCamera->SetPosition(Vector3(1, 1, -1.5) * 1000);
	mPCamera->SetFieldOfViewY(MathHelper::ToRadian(60.0f));
	mPGameComponents->Add(mPCamera, mPGameComponents);


	// fZbgAbv
	mPGameComponents->Add(mPModel, mPGameComponents);
	mPModel->SetCamera(mPCamera);


	// fobOj[ݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceMesh");


	// Gg[Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<ݒ>");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// t@CIGg[ǉ
	SP<MenuEntryStrings> pMEString(NEW MenuEntryStrings());
	pMEString->SetName(_T("FileFullPathsEntry"));
	pMEString->SetText(_T("t@C"));
	
	for (int i = 0; i < mStKFileFullPathCount; ++i)
	{
		pMEString->AddString(mStKPFileFullPaths[i]);
	}

	pMEL->AddMenuEntry(pMEString);


	// eNjbN̎ނ̃Gg[ǉ
	SP<MenuEntryStrings> pMETechnique(NEW MenuEntryStrings());
	pMETechnique->SetName(_T("Technique"));
	pMETechnique->SetText(_T("eNjbN̎"));

	for (int i = 0; i < mStKTechniqueNameCount; ++i)
	{
#if UNICODE
		// Chɕϊ
		TCHAR techniqueName[256];
		StringHelper::ToWideChar(techniqueName, 256, mStKTechniqueNames[i]);

		// ǉ
		pMETechnique->AddString(techniqueName);
#else
		// ǉ
		pMETechnique->AddString(mStKTechniqueNames[i]);
#endif // UNICODE
	}

	pMEL->AddMenuEntry(pMETechnique);


	// Aj[Vt@CǂݍރGg[ǉ
	SP<MenuEntryStrings> pMEAnimationFilePaths(NEW MenuEntryStrings());
	pMEAnimationFilePaths->SetName(_T("AnimationFilePaths"));
	pMEAnimationFilePaths->SetText(_T("Aj[Vt@CpX"));

	for (int i = 0; i < stKAnimationFilePathCount; ++i)
	{
		pMEAnimationFilePaths->AddString(stKPAnimationFilePaths[i]);
	}

	pMEL->AddMenuEntry(pMEAnimationFilePaths);


	// eCN̕ύXGg[ǉ
	SP<MenuEntryStrings> pMETakeNames(NEW MenuEntryStrings());
	pMETakeNames->SetName(_T("TakeNames"));
	pMETakeNames->SetText(_T("eCN"));

	pMETakeNames->AddString(_T("Take 001"));
	pMETakeNames->AddString(_T("Take 002"));

	pMEL->AddMenuEntry(pMETakeNames);


	// Aj[Vԍ̕ύXGg[ǉ
	SP<MenuEntryNumeric<int>> pAnimationNumberEntry(NEW MenuEntryNumeric<int>());
	pAnimationNumberEntry->SetName(_T("AnimationNumber"));
	pAnimationNumberEntry->SetText(_T("Aj[Vԍ"));
	pAnimationNumberEntry->SetNumericPointer(&nAniamtionNumber);

	pMEL->AddMenuEntry(pAnimationNumberEntry);
}

/// 
void DebugSequenceMesh::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// J̓͏
	mPCamera->HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// I𒆂̃j[Gg[Xg擾
	SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();


	// EnterL[ꂽȂ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// I𒆂̃j[Gg[Xg擾
		SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();

		// I𒆂̃Gg[擾
		SP<IMenuEntry> pSelectedME = pMEL->GetSelectedMenuEntry();


		// ǂݍރt@CIGg[Ȃ
		if (_tcscmp(pSelectedME->GetName(), _T("FileFullPathsEntry")) == 0)
		{
			// LXg
			MenuEntryStrings* pFileFullPathEntryStrings = dynamic_cast<MenuEntryStrings*>(pSelectedME.GetSource());

			// LXgłȂ
			if (pFileFullPathEntryStrings)
			{
				// I𒆂̃t@CtpX擾
				const TCHAR* kPSelectedFileFullPath = pFileFullPathEntryStrings->GetSelectedString();

				// ΃pXɕϊ
				const tstring kPAbsFullPath = Directory::ToAbsolutePath(kPSelectedFileFullPath);

				// bVǂݍ
				mPModel->LoadMesh(kPAbsFullPath.c_str());


				/* ȉAAj[Vt@COv */

				//// Aj[VJ
				//mPModel->ReleaseAnimation();


				//// t@C擾
				//TCHAR fileName[Directory::mStKMaxFileName];
				//ZeroMemory(fileName, sizeof(fileName));

				//Directory::GetFileName(kPSelectedFileFullPath, fileName);

				//// fBNgpX擾
				//TCHAR dirBuffer[Directory::mStKMaxDirectory];
				//ZeroMemory(dirBuffer, sizeof(dirBuffer));

				//Directory::GetDirectoryPath(kPSelectedFileFullPath, dirBuffer);

				//// fBNg̑St@C擾
				//std::vector<tstring> fileNames;
				//Directory::GetFileNamesInDirectory(dirBuffer, &fileNames);

				//// t@CŃ[v
				//int fileNameCount = fileNames.size();
				//for (int i = 0; i < fileNameCount; ++i)
				//{
				//	// t@CQ
				//	const tstring& kRFileNameStr = fileNames.at(i);

				//	// ǂݍ񂾃f̃t@CƑOvȂ
				//	bool isMatch = StringHelper::IsMatchHead(kRFileNameStr.c_str(), fileName);
				//	if (isMatch)
				//	{
				//		// fBNgƃt@C
				//		TCHAR animationFileFullPath[StringHelper::mStKDefaultBufferSize];
				//		memcpy(animationFileFullPath, dirBuffer, sizeof(dirBuffer));

				//		StringHelper::Concat(animationFileFullPath, StringHelper::mStKDefaultBufferSize, kRFileNameStr.c_str());

				//		// Aj[Vt@Cǂݍ
				//		mPModel->LoadAnimation(animationFileFullPath);
				//	}
				//}
			}
		}

		// Aj[Vt@CpX̃Gg[擾łȂ
		if (_tcscmp(pSelectedME->GetName(), _T("AnimationFilePaths")) == 0)
		{
			// _ELXg
			SP<MenuEntryStrings> pAnimationFilePathEntry;
			pAnimationFilePathEntry.DownCast(pSelectedME);

			// LXgłȂ
			if (pAnimationFilePathEntry)
			{
				// IĂ镶擾
				const TCHAR* kPSelectedString = pAnimationFilePathEntry->GetSelectedString();

				// Aj[Vt@Cǂݍ
				mPModel->LoadAnimation(kPSelectedString);
			}
		}

		// eCNύXGg[擾łȂ
		if (_tcscmp(pSelectedME->GetName(), _T("TakeNames")) == 0)
		{
			// _ELXg
			SP<MenuEntryStrings> pTakeNamesEntry;
			pTakeNamesEntry.DownCast(pSelectedME);

			// LXgłȂ
			if (pTakeNamesEntry)
			{
				// IĂ镶擾
				const TCHAR* kPSelectedString = pTakeNamesEntry->GetSelectedString();

				// eCNύX
				mPModel->ChangeAnimation(kPSelectedString);
			}
		}

		// Aj[VύXGg[擾łȂ
		if (_tcscmp(pSelectedME->GetName(), _T("AnimationNumber")) == 0)
		{
			// _ELXg
			SP<MenuEntryNumeric<int>> pAnimationNumberEntry;
			pAnimationNumberEntry.DownCast(pSelectedME);

			// LXgłȂ
			if (pAnimationNumberEntry)
			{
				// Aj[VύX
				mPModel->ChangeAnimation(nAniamtionNumber);				
			}
		}
	}

	// eNjbNIGg[擾
	SP<MenuEntryStrings> pTechniqueNameEntry;
	pTechniqueNameEntry.DownCast(pMEL->GetMenuEntry(_T("Technique")));

	// eNjbNIGg[擾łȂ
	if (pTechniqueNameEntry)
	{
		// IĂ镶擾
		const TCHAR* kPSelectedString = pTechniqueNameEntry->GetSelectedString();

		// eNjbNݒ
		mPModel->SetTechnique(kPSelectedString);
	}
}

/// XV
void DebugSequenceMesh::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequenceMesh::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// L[\
	DP(10, 200, 0xff00ffff, _T("WASL[FJ㉺ړ"));
	DP(10, 215, 0xff00ffff, _T("AADL[AEhbOFJ]"));
}


/// t@CȈ
void DebugSequenceMesh::DecideFileName()
{
	PFL(_T("܂"));
}
