#include "Sequence/Debug/DebugSequenceGrid.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceGrid::DebugSequenceGrid()
	: SequenceBase(false)
{
	// Obh2D쐬
	mPGrid2D.SetPointer(NEW Grid2DDX9());

	// Obh3D쐬
	mPGrid3D.SetPointer(NEW Grid3DDX9());

	// J쐬
	mPCamera.SetPointer(NEW Camera3D());
}

/// fXgN^
DebugSequenceGrid::~DebugSequenceGrid()
{
}


/// 
void DebugSequenceGrid::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceGrid>");


	// Gg[Xg쐬AfobOj[ɒǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<Nameless>");

	mPDebugMenu->AddMenuEntryList(pMEL);

	// Obh2D̗񐔃Gg[쐬
	SP< MenuEntryNumeric<int> > pSMEColumn2D(NEW MenuEntryNumeric<int>());
	pSMEColumn2D->SetText(_T(""));
	pSMEColumn2D->SetNumericPointer(&mPGrid2D->GetPropertyRef().mColumnCount);

	pMEL->AddMenuEntry(pSMEColumn2D);

	// Obh2D̍sGg[쐬
	SP< MenuEntryNumeric<int> > pSMERow2D(NEW MenuEntryNumeric<int>());
	pSMERow2D->SetText(_T("s"));
	pSMERow2D->SetNumericPointer(&mPGrid2D->GetPropertyRef().mRowCount);

	pMEL->AddMenuEntry(pSMERow2D);

	// Obh2D̒S\Gg[쐬
	SP<MenuEntryBool> pMECenterVisible(NEW MenuEntryBool());
	pMECenterVisible->SetText(_T("S\"));
	pMECenterVisible->SetBoolPointer(&mPGrid2D->GetPropertyRef().mIsCenterVisible);

	pMEL->AddMenuEntry(pMECenterVisible);


	// Obh2DQ[R|[lgɒǉ
	mPGameComponents->Add(mPGrid2D, mPGameComponents);
	mPGrid2D->SetRenderOrder(1000);


	// Obh3D̃f쐬
	mPGrid3D->CreateGrid(500, 500, 10, 10);
	// MEMO:v~eBȕύX̂CO
	//mPGrid3D->SetRotation(Vector3::UnitX() * MathHelper::ToRadian(-90.0f));

	// Obh3DɃJݒ
	mPGrid3D->SetCamera(mPCamera);

	// Obh3DQ[R|[lgɒǉ
	mPGameComponents->Add(mPGrid3D, mPGameComponents);


	// J
	mPCamera->Initialize();
	mPCamera->SetPosition(Vector3(1, 1, -1) * 20);

	// JQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera, mPGameComponents);
}

/// 
void DebugSequenceGrid::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// pύXx
	float fovySpeed = 0.25f * delta;

	// pύX
	float fovValue = 0;

	// WL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_W))
	{
		fovValue -= fovySpeed;
	}
	// SL[ĂȂ
	else if (pKB->IsDown(Keys::eKEY_S))
	{
		fovValue += fovySpeed;
	}

	// pϓ
	mPCamera->SetFieldOfViewY(mPCamera->GetFieldOfViewY() + fovValue);


	// ]x
	float revolveSpeed = MathHelper::ToRadian(90.0f) * delta;

	// ]
	Vector3 revolveValue;

	// AL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_A))
	{
		revolveValue += Vector3::UnitY() * revolveSpeed;
	}
	// DL[ĂȂ
	else if (pKB->IsDown(Keys::eKEY_D))
	{
		revolveValue += Vector3::UnitY() * -revolveSpeed;
	}

	// ]
	mPCamera->RevolveZXY(revolveValue);
}