#include "Sequence/Debug/DebugSequenceFile.h"

#include "Blast/Storage/Directory.h"
#include "Blast/IO/File.h"
#include "Blast/IO/CSVFile.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Storage;
using namespace Blast::String;
using namespace Blast::IO;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace 
{
	/// t@C̓ǂݍ݂̎ޖ
	const TCHAR* nKPLoadMethodNames[DebugSequenceFile::eLOADMETHOD_COUNT] =
	{
		_T("Xg[g1sɓǂݍ"),
		_T("Xg[gĈꊇǂݍ"),

		_T("FILEg1sɓǂݍ"),
		_T("FILEgĒPꂲƂɓǂݍ"),
		_T("FILEgĈꊇǂݍ"),

		_T("FileNXg1sɓǂݍ"),

		_T("CSVFileNXgēǂݍ"),
	};
}


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// Gg[̔z
const TCHAR* const DebugSequenceFile::mStKPEntryNames[] =
{
	_T(""),
};

/// t@C
const TCHAR* DebugSequenceFile::mStKPFileFullPaths[] =
{
	_T("./Res/Test/Text/Test_UTF16_NO_BOM.txt"),
	_T("./Res/Test/Text/Test_UTF8_BOM.txt"),
	_T("./Res/Test/Text/Test_UTF8_NO_BOM.txt"),
	_T("./Res/Test/Text/Test_SJIS.txt"),
	_T("./Res/Test/Text/Test_HalfOnly_SJIS.txt"),
	_T("./Res/Test/Text/Test_HalfOnly_NO_BOM.txt"),
	_T("./Res/Test/Text/Test_HalfOnly_BOM.txt"),
	_T("./Res/Test/CSV/P1_Item_Equipment.csv"),

};

/// t@C̐
const int DebugSequenceFile::mStKFileFullPathCount = sizeof(mStKPFileFullPaths) / sizeof(mStKPFileFullPaths[0]);


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceFile::DebugSequenceFile()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceFile::~DebugSequenceFile()
{
}


/// 
void DebugSequenceFile::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[ݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceFile");


	// Gg[Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<ݒ>");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// 
	SP<MenuEntry> pMERead(NEW MenuEntry());
	pMERead->SetText(_T("<ǂݍ>"));

	pMEL->AddMenuEntry(pMERead);


	// t@CIGg[ǉ
	SP<MenuEntryStrings> pMEString(NEW MenuEntryStrings());
	pMEString->SetName(_T("ReadFile"));
	pMEString->SetText(_T("t@C"));
	
	for (int i = 0; i < mStKFileFullPathCount; ++i)
	{
		pMEString->AddString(mStKPFileFullPaths[i]);
	}

	pMEL->AddMenuEntry(pMEString);


	// ǂݍ݂̎ނIGg[ǉ
	SP<MenuEntryStrings> pMELoadMethod(NEW MenuEntryStrings());
	pMELoadMethod->SetName(_T("RaadMethod"));
	pMELoadMethod->SetText(_T("ǂݍ݂̎"));

	for (int i = 0; i < eLOADMETHOD_COUNT; ++i)
	{
		pMELoadMethod->AddString(nKPLoadMethodNames[i]);
	}

	pMEL->AddMenuEntry(pMELoadMethod);

	// ǂݍ݂̎s
	SP<MenuEntry> pMEReadExe(NEW MenuEntry());
	pMEReadExe->SetName(_T("ReadExe"));
	pMEReadExe->SetText(_T("ǂݍ݂s"));

	pMEL->AddMenuEntry(pMEReadExe);


	// ݐݒ
	SP<MenuEntry> pMEWrite(NEW MenuEntry());
	pMEWrite->SetText(_T("<>"));

	pMEL->AddMenuEntry(pMEWrite);

	// ݂̎s
	SP<MenuEntry> pMEWriteExe(NEW MenuEntry());
	pMEWriteExe->SetName(_T("WriteExe"));
	pMEWriteExe->SetText(_T("݂s"));

	pMEL->AddMenuEntry(pMEWriteExe);
}

/// 
void DebugSequenceFile::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// EnterL[ꂽȂ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// I𒆂̃j[Gg[Xg擾
		SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();

		// I𒆂̃Gg[擾
		SP<IMenuEntry> pSelectedEntry = pMEL->GetSelectedMenuEntry();


		// ǂݍ݂sGg[Ȃ
		if (_tcscmp(pSelectedEntry->GetName(), _T("ReadExe")) == 0)
		{
			// t@CIGg[擾
			SP<MenuEntryStrings> pFileFullPathEntry;
			pFileFullPathEntry.DownCast(pMEL->GetMenuEntry(_T("ReadFile")));

			// Gg[擾łȂ
			if (pFileFullPathEntry)
			{
				// ǂݍ݂̎ނIGg[擾
				SP<MenuEntryStrings> pLoadMethodEntry;
				pLoadMethodEntry.DownCast(pMEL->GetMenuEntry(_T("RaadMethod")));

				// Gg[擾Ȃ
				if (pLoadMethodEntry)
				{
					// I𒆂̃t@CtpX擾
					const TCHAR* kPSelectedFileFullPath = pFileFullPathEntry->GetSelectedString();

					// ΃pXɕϊ
					const tstring kPAbsFullPath = Directory::ToAbsolutePath(kPSelectedFileFullPath);


					// ǂݍ݂̎ނŕ
					int loadMethodIndex = pLoadMethodEntry->GetSelectedIndex();
					switch (loadMethodIndex)
					{
						/// Xg[g1sɓǂݍ
						case eLOADMETHOD_STREAM_LINES:		LoadStreamLines(kPAbsFullPath.c_str());
							break;

						/// Xg[găXg[gĈꊇǂݍ
						case eLOADMETHOD_STREAM_BULK:		LoadStreamBulk(kPAbsFullPath.c_str());
							break;


						/// FILEg1sƂɓǂݍ
						case eLOADMETHOD_FILE_LINE:			LoadFileLine(kPAbsFullPath.c_str());
							break;

						/// FILEgĒPꂲƂɓǂݍ
						case eLOADMETHOD_FILE_WORD:			LoadFileWord(kPAbsFullPath.c_str());
							break;

						/// FILEgĈꊇǂݍ
						case eLOADMETHOD_FILE_BULK:			LoadFileBulk(kPAbsFullPath.c_str());
							break;


						/// FileNXg1sƂɓǂݍ
						case eLOADMETHOD_FILECLASS_LINE:	LoadFileClassLine(kPAbsFullPath.c_str());
							break;


						/// CSVFileNXgēǂݍ
						case eLOADMETHOD_CSVFILECLASS:		LoadFileCSV(kPAbsFullPath.c_str());
							break;

						default:
							break;
					};
				}
			}
		}


		// ݂sGg[Ȃ
		if (_tcscmp(pSelectedEntry->GetName(), _T("WriteExe")) == 0)
		{
			// 
			WriteFileBulk(_T("./DebugWriteFile.txt"));
		}
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// Xg[g1sƂɓǂݍ
void DebugSequenceFile::LoadStreamLines(const TCHAR* kPFullPath)
{
	// s
	int lineCount = 0;


	// ^C}[쐬
	Timer loadTimer;

	// ^C}[Jn
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_STREAM_LINES]);
	{
		// t@CWJ
		std::basic_ifstream<TCHAR> stream(kPFullPath);

		// t@CWJɐȂ
		if (stream.good())
		{
			// EOFɂȂ܂
			while (!stream.eof())
			{
				// MEMO:Ђsǂݍ݂܂B
				// s̃obt@
				const int kLineBufferSize = 1024 * 4;
				TCHAR lineBuffer[kLineBufferSize];

				// sǂݍ
				stream.getline(lineBuffer, kLineBufferSize);

				// _v
				//PFL(_T("%s"), lineBuffer);

				// sJEg
				++lineCount;
			}


			// t@C
			stream.close();
		}
	}
	// ^C}[I
	loadTimer.End();

	// o
	PFL(_T("t@C:%s"), kPFullPath);
	loadTimer.OutputResult();
	PFL(_T("s:%d"), lineCount); 
}

/// Xg[gĈꊇǂݍ
void DebugSequenceFile::LoadStreamBulk(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;

	// ^C}[Jn
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_STREAM_BULK]);
	{
		// t@CWJ
		std::basic_ifstream<TCHAR> stream;
		stream.open(kPFullPath);


		{
			// bv^Co
			loadTimer.OutputLapTime();
		}


		// WJɐȂ
		if (stream.good())
		{
			// t@CTCY擾
			stream.seekg(0, std::ios_base::end);

			int fileSize = stream.tellg();

			stream.clear();
			stream.seekg(0, std::ios_base::beg);


			{
				// bv^Co
				loadTimer.OutputLapTime();
			}


			// obt@
			TCHAR* pBuffer = NEW TCHAR[fileSize];

			// Cɓǂݍ
			stream.read(pBuffer, fileSize);


			{
				// bv^Co
				loadTimer.OutputLapTime();
			}


			// pobt@
			const int kSplitBufferSize = 1024 * 10;
			TCHAR* pSplitBuffers[kSplitBufferSize];
			ZeroMemory(pSplitBuffers, sizeof(pSplitBuffers));

			int splitCount = 0;

			StringHelper::Split(pBuffer, _T("\n"), pSplitBuffers, &splitCount);

			PFL(_T("ǂݍݏIB"));


			// obt@
			SAFE_DELETE_ARRAY(pBuffer);
			
			// t@C
			stream.close();
		}
	}
	// ^C}[I
	loadTimer.End();


	// o
	PFL(_T("t@C:%s"), kPFullPath);
	loadTimer.OutputResult();
}


/// FILEg1sƂɓǂݍ
void DebugSequenceFile::LoadFileLine(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_FILE_LINE]);
	{
		// t@CWJ
		FILE* pFile = NULL;
		_tfopen_s(&pFile, kPFullPath, _T("rt"));

		// WJɐȂ
		if (pFile)
		{
			// obt@
			const int kBufferLength = 1024;
			TCHAR buffer[kBufferLength];
			ZeroMemory(buffer, sizeof(buffer));

			// obt@
			const int kSplitBufferSize = 1024 * 4;
			TCHAR* splitBuffers[kSplitBufferSize];
			ZeroMemory(splitBuffers, sizeof(splitBuffers));

			int splitCount = 0;


			// CAUTION:[v
			// EOF܂Ń[v
			while (!feof(pFile))
			{
				// ǂݍ
				ZeroMemory(buffer, sizeof(buffer));
				_fgetts(buffer, kBufferLength, pFile);

				// 
				ZeroMemory(splitBuffers, sizeof(splitBuffers));
				StringHelper::Split(buffer, _T(" "), splitBuffers, &splitCount);
			}


			// t@C
			fclose(pFile);
		}
	}
	// ^C}[I
	loadTimer.End();


	// o
	PFL(_T("t@C:%s"), kPFullPath);
	loadTimer.OutputResult();
}

/// FILEgĒPꂲƂɓǂݍ
void DebugSequenceFile::LoadFileWord(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_FILE_WORD]);
	{
		// t@CWJ
		FILE* pFile = NULL;
		_tfopen_s(&pFile, kPFullPath, _T("rt"));

		// WJɐȂ
		if (pFile)
		{
			// obt@
			const int kBufferLength = 1024;
			TCHAR buffer[kBufferLength];
			ZeroMemory(buffer, sizeof(buffer));

			// CAUTION:[v
			// EOF܂Ń[v
			while (!feof(pFile))
			{
				// ǂݍ
				_ftscanf_s(pFile, _T("%s "), buffer, kBufferLength);

				//// MEMO:_v͂ƂĂdȂ܂B
				//PFL(_T("%s"), buffer);
			}


			// t@C
			fclose(pFile);
		}
	}
	// ^C}[I
	loadTimer.End();


	// o
	PFL(_T("t@C:%s"), kPFullPath);
	loadTimer.OutputResult();
}

/// FILEgĈꊇǂݍ
void DebugSequenceFile::LoadFileBulk(const TCHAR* kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_FILE_BULK]);
	{
		// t@CWJ
		FILE* pFile = NULL;
		_tfopen_s(&pFile, kPFullPath, _T("rt"));

		// WJɐȂ
		if (pFile)
		{
			// t@CTCY擾
			fseek(pFile, 0, SEEK_END);
			const long kFileSize = ftell(pFile);
			fseek(pFile, 0, SEEK_SET);


			// obt@
			SP<TCHAR> pBuffer(NEW TCHAR[kFileSize], true);
			int sizeBuffer = sizeof(TCHAR) * kFileSize;
			ZeroMemory(pBuffer.GetSource(), sizeBuffer);

			// ǂݍ
			fread(pBuffer.GetSource(), sizeof(TCHAR), kFileSize, pFile);


			// 
			const int kSplitBufferCount = 1024 * 4;
			TCHAR* splitBuffers[kSplitBufferCount];
			ZeroMemory(splitBuffers, sizeof(splitBuffers));

			int splitCount = 0;

			StringHelper::Split(pBuffer.GetSource(), _T("\n"), splitBuffers, &splitCount);


			// t@C
			fclose(pFile);
		}
	}
	// ^C}[I
	loadTimer.End();


	// o
	PFL(_T("t@C:%s"), kPFullPath);
	loadTimer.OutputResult();
}

/// FileNXg1sɓǂݍ
void DebugSequenceFile::LoadFileClassLine(const TCHAR* kPFullPath)
{
	// ^C}[p
	Timer loadTimer;

	// ^C}[Jn
	loadTimer.Start(nKPLoadMethodNames[eLOADMETHOD_FILECLASS_LINE]);
	{
		// t@CWJ
		File file;
		file.Open(kPFullPath);


		// 1s̃obt@
		const int kLineBufferCount = 1024 * 4;
		TCHAR lineBuffer[kLineBufferCount];

		// pobt@
		const int kSplitBufferCount = 256 * 4;
		TCHAR* splitBuffers[kSplitBufferCount];

		// EOFɂȂ܂
		while (!file.IsEOF())
		{
			// 1sǂݍ
			file.ReadLine(lineBuffer);

			// 
			int splitCount = 0;
			StringHelper::Split(lineBuffer, _T(" \n"), splitBuffers, &splitCount);
		}
	}
	// ^C}[I
	loadTimer.End();

	// ^C}[̌ʂo
	loadTimer.OutputResult();
}


/// FileNXgĈꊇ
void DebugSequenceFile::WriteFileBulk(const TCHAR* kPFullPath)
{
	// ^C}[p
	Timer loadTimer;

	// ^C}[Jn
	loadTimer.Start(_T("FileNXgĈꊇ"));
	{
		// t@CWJ
		File file;
		file.Open(kPFullPath, _T("w"));


		// ޕ
		const TCHAR* kPText = _T("lBSFCŁu|sXv{CŗVł݂܂B\n{lB͎Ė{CŃvCĂ܂ArO͂̕@B");
		file.WriteLine(kPText);
	}
	// ^C}[I
	loadTimer.End();

	// ^C}[̌ʂo
	loadTimer.OutputResult();
}


/// CSVFileNXgēǂݍ
void DebugSequenceFile::LoadFileCSV(const TCHAR* kPFullPath)
{
	CSVFile csv(kPFullPath);
	bool isSucceeded = csv.Create();

	// ǂݍ݂ɎsȂ
	if (!isSucceeded)
	{
		return;
	}


	// e[u擾
	SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kRecordCount = pTable->GetRecordCount();
	for (int i = 0; i < kRecordCount; ++i)
	{
		SP<CSVRecord> pRecord = pTable->GetRecord(i);


		// o
		for (int j = 0; j < pRecord->GetItemCount(); ++j)
		{
			const CSVRecord::SField* kPSField = pRecord->GetItem(j);
			PFL(_T("O=%s, l=%s"), kPSField->GetColumnName(), kPSField->GetValueRef().GetValueStrRef().c_str());
		}
		PFL(_T(""));
	}
}