#ifndef SEQUENCE_DEBUG_DEBUGSEQUENCEFADE_H
#define SEQUENCE_DEBUG_DEBUGSEQUENCEFADE_H

#include "Blast/Base/SequenceBase.h"
#include "Blast/Base/IGameComponent.h"
#include "Camera2D.h"
#include "Blast/Graphic/Fade.h"

namespace Sequence
{
	namespace Debug
	{
		/// |S`̋@\{V[PX
		class DebugSequenceFade : public Blast::Base::SequenceBase
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// [eNX`̃t@CtpXQ
			static const TCHAR* mStKPRuleTextureFullPaths[];

			/// [eNX`̃t@CtpX̐
			static const int mStKRuleTextureFullPathCount;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			DebugSequenceFade();

			/// fXgN^
			virtual ~DebugSequenceFade();


			/// 
			virtual void Initialize();

			/// 
			virtual void HandleInput(float delta);

			/// `
			virtual void Render();

		private:
			/// J
			SP<Camera2D> mPCamera;

			/// tF[h
			SP<Blast::Graphic::Fade> mPFade;


			/// pԕb
			double mDurationTime;

			/// ptF[hF
			Blast::Graphic::Color mFadeColor;

			/// ptF[h
			int mDirectionIndex;

			/// fBt[YeNX`gǂ
			bool mIsUseDiffuseTexture;

			/// fBt[YeNX`̃t@CI郁j[Gg[
			SP<Blast::Base::MenuEntryStrings> mPEntryDiffuseTexturePath;

			/// [eNX`̃t@CI郁j[Gg[
			SP<Blast::Base::MenuEntryStrings> mPEntryRuleTexturePath;

			/// jo[Tǂ
			bool mIsUniversal;
		};
	} // namespace Debug
} // namespace Sequence 


#endif // SEQUENCE_DEBUG_DEBUGSEQUENCEFADE_H
