#include "Sequence/Debug/DebugSequenceFade.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// [eNX`̃t@CtpXQ
const TCHAR* DebugSequenceFade::mStKPRuleTextureFullPaths[] =
{
	_T("./Res/Test/Texture/Rule_000.png"),
	_T("./Res/Test/Texture/Rule_001.png"),
	_T("./Res/Test/Texture/Rule_002.png"),
	_T("./Res/Test/Texture/Rule_003.jpg"),
	_T("./Res/Test/Texture/Rule_004.jpg"),
	_T("./Res/Test/Texture/Rule_005.jpg"),
	_T("./Res/Test/Texture/Rule_006.jpg"),
	_T("./Res/Test/Texture/Rule_007.jpg"),
	_T("./Res/Test/Texture/Rule_008.jpg"),
	_T("./Res/Test/Texture/Rule_009.jpg"),
	_T("./Res/Test/Texture/Rule_010.jpg"),
	_T("./Res/Test/Texture/Rule_011.jpg"),
	_T("./Res/Test/Texture/Rule_012.jpg"),
	_T("./Res/Test/Texture/Reimu.jpg"),
	_T("./Res/Test/Texture/Mana.png"),
};

/// [eNX`̃t@CtpX̐
const int DebugSequenceFade::mStKRuleTextureFullPathCount = sizeof(mStKPRuleTextureFullPaths) / sizeof(mStKPRuleTextureFullPaths[0]);


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceFade::DebugSequenceFade()
	: SequenceBase(false)
{
	// J쐬
	mPCamera.SetPointer(NEW Camera2D());


	// tF[h쐬
	mPFade.SetPointer(NEW Fade());


	// p@֕bݒ
	mDurationTime = 1.0f;

	// ptF[hFݒ
	mFadeColor = ColorCode::ToCode(ColorCode::eCOLOR_WHITE);

	// ptF[hݒ
	mDirectionIndex = Fade::eDIRECTION_IN;


	// fBt[YeNX`gǂݒ
	mIsUseDiffuseTexture = false;


	// jo[Tǂݒ
	mIsUniversal = true;
}

/// fXgN^
DebugSequenceFade::~DebugSequenceFade()
{
}


/// 
void DebugSequenceFade::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = (_T("DebugSequenceFade"));


	// fobOj[̃Gg[Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("Gg[Xg");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// ԕbGg[ɒǉ
	SP< MenuEntryNumeric<double> > pMEDurationTime(NEW MenuEntryNumeric<double>());
	pMEDurationTime->SetText(_T(""));
	pMEDurationTime->SetNumericPointer(&mDurationTime);
	pMEDurationTime->SetStep(0.1);

	pMEL->AddMenuEntry(pMEDurationTime);


	// ptF[hF̃Gg[
	const TCHAR* kPFadeColorEntryNames[] =
	{
		_T("tF[hFR"),
		_T("tF[hFG"),
		_T("tF[hFB"),
		_T("tF[hFA"),
	};

	// F̗vfŃ[v
	for (int i = 0; i < Color::mStKColorFactorCount; ++i)
	{
		// ptF[hFGg[ɒǉ
		SP< MenuEntryNumeric<float> > pMEFadeColor(NEW MenuEntryNumeric<float>());
		pMEFadeColor->SetText(kPFadeColorEntryNames[i]);
		pMEFadeColor->SetNumericPointer(&mFadeColor.GetArray()[i]);
		pMEFadeColor->SetStep(0.05f);
		pMEFadeColor->SetLimitOver(1.0f);
		pMEFadeColor->SetLimitUnder(0.0f);

		pMEL->AddMenuEntry(pMEFadeColor);
	}


	// ptF[hGg[ɒǉ
	SP< MenuEntryNumeric<int> > pMEDirection(NEW MenuEntryNumeric<int>());
	pMEDirection->SetText(_T("tF[h"));
	pMEDirection->SetNumericPointer(&mDirectionIndex);
	pMEDirection->SetStep(1);
	pMEDirection->SetLimitOver(1);
	pMEDirection->SetLimitUnder(0);

	pMEL->AddMenuEntry(pMEDirection);


	// fBt[YeNX`gǂGg[ɒǉ
	SP<MenuEntryBool> pMEUseDiffuse(NEW MenuEntryBool());
	pMEUseDiffuse->SetText(_T("fBt[Yg"));
	pMEUseDiffuse->SetBoolPointer(&mIsUseDiffuseTexture);

	pMEL->AddMenuEntry(pMEUseDiffuse);


	// fBt[YeNX`CfbNXGg[ɒǉ
	mPEntryDiffuseTexturePath.SetPointer(NEW MenuEntryStrings());
	mPEntryDiffuseTexturePath->SetText(_T("fBt[YeNX`"));
	for (int i = 0; i < mStKRuleTextureFullPathCount; ++i)
	{
		mPEntryDiffuseTexturePath->AddString(mStKPRuleTextureFullPaths[i]);
	}

	pMEL->AddMenuEntry(mPEntryDiffuseTexturePath);


	// [eNX`CfbNXGg[ɒǉ
	mPEntryRuleTexturePath.SetPointer(NEW MenuEntryStrings());
	mPEntryRuleTexturePath->SetText(_T("[eNX`"));
	for (int i = 0; i < mStKRuleTextureFullPathCount; ++i)
	{
		mPEntryRuleTexturePath->AddString(mStKPRuleTextureFullPaths[i]);
	}

	pMEL->AddMenuEntry(mPEntryRuleTexturePath);


	// jo[TǂGg[ɒǉ
	SP<MenuEntryBool> pMEUniversal(NEW MenuEntryBool());
	pMEUniversal->SetText(_T("jo[Tǂ"));
	pMEUniversal->SetBoolPointer(&mIsUniversal);

	pMEL->AddMenuEntry(pMEUniversal);


	// JQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera, mPGameComponents);

	// tF[hQ[R|[lgɒǉ
	mPGameComponents->Add(mPFade, mPGameComponents);
}

/// 
void DebugSequenceFade::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[hQ
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// EnterL[ꂽ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// fBt[YeNX`gȂ
		if (mIsUseDiffuseTexture)
		{
			// fBt[YeNX`ǂݍ
			SP<FileTexture2DDX9> pTexture(NEW FileTexture2DDX9());
			bool isSuccess = pTexture->Load(mPEntryDiffuseTexturePath->GetSelectedString());
			if (isSuccess)
			{
				mPFade->SetDiffuseTexture(pTexture);
			}
		}
		// fBt[YeNX`gȂȂ
		else
		{
			// ǂݍłȂeNX`n
			SP<FileTexture2DDX9> pTexture(NEW FileTexture2DDX9());
			mPFade->SetDiffuseTexture(pTexture);
		}

		// [eNX`ǂݍ
		SP<FileTexture2DDX9> pTexture(NEW FileTexture2DDX9());
		bool isSuccess = pTexture->Load(mPEntryRuleTexturePath->GetSelectedString());
		if (isSuccess)
		{
			mPFade->SetRuleTexture(pTexture);
		}

		// tF[hJn
		mPFade->SetDirection(static_cast<Fade::EDirection>(mDirectionIndex));
		mPFade->SetDurationTime(mDurationTime);
		mPFade->SetColor(mFadeColor);

		// jo[TȂ
		if (mIsUniversal)
		{
			mPFade->StartUniversal();
		}
		// jo[TŖȂ
		else
		{
			mPFade->StartFade();
		}
	}

	// PL[ꂽ
	if (pKB->IsJustDown(Keys::eKEY_P))
	{
		// tF[ḧꎞ~gOύX
		if (mPFade->IsPause())
		{
			mPFade->Resume();
		}
		else
		{
			mPFade->Pause();
		}
	}
}

/// `
void DebugSequenceFade::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// tF[h̐i`
	double percentage = mPFade->GetPercentage();
	DP(400, 30, 0xffff0000, _T("tF[h̐i:%lf"), percentage);
}