#include "Sequence/Debug/DSStaticModelViewer.h"

#include "Blast/Graphic/DirectX9/MeshFbxStaticDX9.h"
#include "Camera3DOperation.h"
#include "CharacterDatabase.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// f̃t@CpX
	const TCHAR* const nKPModelFilePaths[] =
	{
		// __eXgf__
		_T("./Res/Model/__TEST__/Thousand/Mesh.FBX"),
		_T("./Res/Model/__TEST__/TwoMaterialsTile/Mesh.FBX"),

		// ACe
		_T("./Res/Model/DropItem/Box/Mesh.FBX"),
		_T("./Res/Model/DropItem/EXE/Mesh.FBX"),
		_T("./Res/Model/DropItem/Patch/Mesh.FBX"),
		_T("./Res/Model/DropItem/Pendant/Mesh.FBX"),
		_T("./Res/Model/DropItem/Shield/Mesh.FBX"),
		_T("./Res/Model/DropItem/Weapon/Mesh.FBX"),

		// ̊Kwւ̃^C
		_T("./Res/Model/NextFloorTile/00_MagicCircle/Mesh.FBX"),

		// ^CS
		_T("./Res/Model/Tile/Tile_0/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_1/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_2/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_3/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_4/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_5/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_6/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_7/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_8/Mesh.FBX"),
		_T("./Res/Model/Tile/Tile_9/Mesh.FBX"),

		// 
		_T("./Res/Model/Trap/_Dummy/Mesh.FBX"),

		// 
		_T("./Res/Model/Wall/Wall_0/Mesh.FBX"),
		_T("./Res/Model/Wall/Wall_1/Mesh.FBX"),
		_T("./Res/Model/Wall/Wall_2/Mesh.FBX"),
		_T("./Res/Model/Wall/Wall_3/Mesh.FBX"),
		_T("./Res/Model/Wall/Wall_4/Mesh.FBX"),
		_T("./Res/Model/Wall/Wall_5/Mesh.FBX"),

		// LN^[
		_T("./Res/Model/Characters/98_KirisameMarisa/KirisameMarisa.FBX"),
		_T("./Res/Model/Characters/99_Celsius/Celsius.FBX"),
		_T("./Res/Model/Characters/102_IzayoiSakuya/Mesh.FBX"),
	};

	/// f̃t@CpX̐
	const int nKModelFilePathCount = SIZE_OF_ARRAY(nKPModelFilePaths);
	

	/// VF[_[̃t@CpX
	const TCHAR* const nKPShaderFilePaths[] =
	{
		ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT),
		ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_LAMBERT),
		ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_PHONG),
		ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_PRIMITIVE),
	};

	/// VF[_[̃t@CpX̐
	const int nKShaderFilePathCount = SIZE_OF_ARRAY(nKPShaderFilePaths);


	/// ǉCX^X̐BfobOj[ŎgB
	int nAddInstanceCount = 1;

	/// ʒuݒ肷CX^X̃CfbNXBfobOj[ŎgB
	int nSetPositionInstanceIndex = 0;

	/// ݒ肷CX^ẌʒuB3WBfobOj[ŎgB
	float nSetPositionInstanceValues[3] = { 0.0f, 0.0f, 0.0f };
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DSStaticModelViewer::DSStaticModelViewer()
	: SequenceBase(false)
{
}

/// fXgN^
DSStaticModelViewer::~DSStaticModelViewer()
{
}


/// 
void DSStaticModelViewer::Initialize()
{
	// ̏
	SequenceBase::Initialize();

	// J
	mPCamera.SetPointer(NEW Camera3DOperation());
	mPCamera->SetLookAt(Vector3::UnitY() * 0.0f);
	mPCamera->SetPosition(Vector3(1, 1, -1) * 300.0f);

	// XYZ
	mPXYZAxis.SetPointer(NEW XYZAxisDX9());
	mPXYZAxis->SetCamera(mPCamera);
	mPXYZAxis->SetLength(500.0f);

	// Obh쐬
	mPGrid.SetPointer(NEW GridDX9());
	mPGrid->Create(1000.0f, 50.0f);
	mPGrid->SetCamera(mPCamera);


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DSStaticModelViewer>");

	// Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->SetName(_T("ÓIf"));
	pMEL->SetPosition(Vector3(10, 30, 0));
	mPDebugMenu->AddMenuEntryList(pMEL);
	

	// f̃Xgǉ
	SP<MenuEntryStrings> pME(NEW MenuEntryStrings());
	pME->SetName(_T("f"));
	pME->SetText(_T("f"));
	pMEL->AddMenuEntry(pME);
	for (int i = 0; i < nKModelFilePathCount; ++i)
	{
		pME->AddString(nKPModelFilePaths[i]);
	}
	
	// VF[_[
	SP<MenuEntryStrings> pMEShader(NEW MenuEntryStrings());
	pMEShader->SetName(_T("VF[_["));
	pMEShader->SetText(_T("VF[_["));
	pMEL->AddMenuEntry(pMEShader);
	for (int i = 0; i < nKShaderFilePathCount; ++i)
	{
		pMEShader->AddString(nKPShaderFilePaths[i]);
	}


	// CX^Xǉ
	SP<MenuEntryNumeric<int>> pMEInstanceAdd(NEW MenuEntryNumeric<int>());
	pMEInstanceAdd->SetNumericPointer(&nAddInstanceCount);
	pMEInstanceAdd->SetLimitUnder(1);
	pMEInstanceAdd->SetLimitOver(10);
	pMEInstanceAdd->SetStep(1);
	pMEInstanceAdd->SetName(_T("CX^Xǉ"));
	pMEInstanceAdd->SetText(_T("CX^Xǉ"));
	pMEL->AddMenuEntry(pMEInstanceAdd);

	// CX^Xʒuݒ
	SP<MenuEntryNumeric<int>> pMEInstancePosIndex(NEW MenuEntryNumeric<int>());
	pMEInstancePosIndex->SetNumericPointer(&nSetPositionInstanceIndex);
	pMEInstancePosIndex->SetLimitUnder(0);
	pMEInstancePosIndex->SetLimitOver(0);
	pMEInstancePosIndex->SetStep(1);
	pMEInstancePosIndex->SetName(_T("CX^XʒuCfbNX"));
	pMEInstancePosIndex->SetText(_T("CX^XʒuCfbNX"));
	pMEL->AddMenuEntry(pMEInstancePosIndex);

	SP<MenuEntryNumeric<float>> pMEInstancePosValues[3];
	for (int i = 0; i < 3; ++i)
	{
		pMEInstancePosValues[i].SetPointer(NEW MenuEntryNumeric<float>());
		pMEInstancePosValues[i]->SetNumericPointer(&nSetPositionInstanceValues[i]);
		pMEInstancePosValues[i]->SetLimitUnder(-1000.0f);
		pMEInstancePosValues[i]->SetLimitOver(1000.0f);
		pMEInstancePosValues[i]->SetStep(10.0f);
		pMEInstancePosValues[i]->SetName(StringHelper::Format(_T("CX^Xʒu%d"), i).c_str());
		pMEInstancePosValues[i]->SetText(StringHelper::Format(_T("CX^Xʒu%d"), i).c_str());
		pMEL->AddMenuEntry(pMEInstancePosValues[i]);
	}
}

/// 
void DSStaticModelViewer::HandleInput(float delta)
{
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// ̓͏
	SequenceBase::HandleInput(delta);

	// J̓͏
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->HandleInput(delta);
	}

	
	// 肵珈
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntry> pMenuEntry = mPDebugMenu->GetSelectedMenuEntryList()->GetSelectedMenuEntry();

		// fǂݍ
		if (_tcscmp(pMenuEntry->GetName(), _T("f")) == 0 ||
			_tcscmp(pMenuEntry->GetName(), _T("VF[_[")) == 0)
		{
			SP<MenuEntryStrings> pMEModelFilePath;
			SP<MenuEntryStrings> pMEShaderFilePath;
			pMEModelFilePath.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("f")));
			pMEShaderFilePath.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("VF[_[")));

			const TCHAR* kPModelFilePath = pMEModelFilePath->GetSelectedString();
			const TCHAR* kPShaderFilePath = pMEShaderFilePath->GetSelectedString();

			// fǂݍ
			mPModel.SetPointer(NEW StaticModelDX9());
			mPModel->LoadMesh(kPModelFilePath);

			// VF[_[͂ĂȂƃG[o
			SP<ShaderEffectDX9> pShader = ResourceManager::GetInstance()->Load<ShaderEffectDX9>(kPShaderFilePath);
			mPModel->SetShaderEffect(pShader);

			// Jݒ肵ȂƃG[o
			mPModel->SetCamera(mPCamera);
		}

		// CX^Xǉ
		if (_tcscmp(pMenuEntry->GetName(), _T("CX^Xǉ")) == 0)
		{
			SP<MenuEntryNumeric<int>> pMEInstanceAdd;
			pMEInstanceAdd.DownCast(pMenuEntry);
			if (mPModel)
			{
				mPModel->AddInstance(*pMEInstanceAdd->GetNumericPointer());

				// CX^XʒuCfbNX̏ύXĂ
				SP<MenuEntryNumeric<int>> pMESetPosInstanceIndex;
				pMESetPosInstanceIndex.DownCast(mPDebugMenu->GetSelectedMenuEntryList()->GetMenuEntry(_T("CX^XʒuCfbNX")));
				pMESetPosInstanceIndex->SetLimitOver(mPModel->GetInstanceCount() - 1);
			}
		}

		// CX^Ẍʒuݒ肷
		bool isSetInstancePosition = false;
		for (int i = 0; i < 3; ++i)
		{
			TCHAR tgtEntryName[StringHelper::mStKDefaultBufferSize];
			StringHelper::Format(tgtEntryName, StringHelper::mStKDefaultBufferSize, _T("CX^Xʒu%d"), i);
			if (_tcscmp(pMenuEntry->GetName(), tgtEntryName) == 0)
			{
				isSetInstancePosition |= true;
			}
		}
		if (isSetInstancePosition)
		{
			if (mPModel)
			{
				D3DXVECTOR4& rPos = mPModel->GetInstanceDatas().at(nSetPositionInstanceIndex).mPosition;
				rPos.x = nSetPositionInstanceValues[0];
				rPos.y = nSetPositionInstanceValues[1];
				rPos.z = nSetPositionInstanceValues[2];
			}
		}
	}
}

/// XV
void DSStaticModelViewer::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	// JXV
	SP<Camera3DOperation> pCamera;
	if (pCamera.DownCast(mPCamera))
	{
		pCamera->Update(delta);
	}

	// LN^[XV
	if (mPModel)
	{
		mPModel->Update(delta);
	}

	// XYZXV
	if (mPXYZAxis)
	{
		mPXYZAxis->Update(delta);
	}
}

/// `
void DSStaticModelViewer::Render()
{
	// ̕`揈
	SequenceBase::Render();

	// XYZ`
	if (mPXYZAxis)
	{
		mPXYZAxis->Render();
	}

	// Obh`
	if (mPGrid)
	{
		mPGrid->Render();
	}

	// f`
	if (mPModel)
	{
		mPModel->Render();
	}
}