#include "Sequence/Debug/DSMap.h"

#include "MapDataManager.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DSMap::DSMap()
	: SequenceBase(false)
	, mPCamera(NEW Camera3DOperation())
	, mPGrid(NEW GridDX9())
	, mPXYZAxis(NEW XYZAxisDX9())
	, mFloorID(0)
	, mClipCenterTilePoint(
		MapDataManager::MAX_TILE_HORIZON_COUNT / 2,
		MapDataManager::MAX_TILE_VERTICAL_COUNT / 2)
{
}

/// fXgN^
DSMap::~DSMap()
{
}


/// 
void DSMap::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// J
	mPGameComponents->Add(mPCamera, mPGameComponents);
	mPCamera->Initialize();
	mPCamera->SetPosition(Vector3(1, 1, -1) * 300);

	// Obh
	mPGrid->Create();
	mPGrid->SetCamera(mPCamera);

	// XYZ
	mPGameComponents->Add(mPXYZAxis);
	mPXYZAxis->SetLength(100.0f);
	mPXYZAxis->SetCamera(mPCamera);


#if _DEBUG
	// fobOj[쐬
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DSMap>");

	// Xg쐬
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<Nameless>");
	mPDebugMenu->AddMenuEntryList(pMEL);

	// tAID
	SP< MenuEntryNumeric<int> > pMEFloorID(NEW MenuEntryNumeric<int>());
	pMEFloorID->SetName(_T("tAID"));
	pMEFloorID->SetText(_T("tAID"));
	pMEFloorID->SetNumericPointer(&mFloorID);
	pMEL->AddMenuEntry(pMEFloorID);

	/// `悷^C̒S
	SP< MenuEntryNumeric<int> > pMEClipTilePoints[2];
	for (int i = 0; i < 2; ++i)
	{
		pMEClipTilePoints[i].SetPointer(NEW MenuEntryNumeric<int>());
		pMEClipTilePoints[i]->SetName(_T("Nbv^Cʒu"));
		pMEClipTilePoints[i]->SetText(_T("Nbv^Cʒu"));
		pMEClipTilePoints[i]->SetNumericPointer(&mClipCenterTilePoint[i]);
		pMEL->AddMenuEntry(pMEClipTilePoints[i]);
	}
#endif // _DEBUG

	// J̕ϐ|C^Ŏ擾Ă\bhj߁A@\ȂȂ܂B
	//// J̎p\Gg[쐬
	//SP< MenuEntryNumeric<float> > pMEFOVY(NEW MenuEntryNumeric<float>());
	//pMEFOVY->SetText(_T("p"));
	//pMEFOVY->SetNumericPointer(mPCamera->GetFieldOfViewY());
	//pMEFOVY->SetStep(0.01f);
	//pMEL->AddMenuEntry(pMEFOVY);
}

/// 
void DSMap::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);

	// J̓͏
	mPCamera->HandleInput(delta);


	// @mMVCς̂ŕsvɂȂ܂B
	//// ͂ŃtAǂݍ
	//IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	//if (pKB->IsJustDown(Keys::eKEY_RETURN))
	//{
	//	mPFloor.SetPointer(NEW Terrain());
	//	mPFloor->CreateTerrain(mFloorID);
	//}
}

/// XV
void DSMap::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);

	// @mMVCς̂ŕsvɂȂ܂B
	//// tA̍XV
	//if (mPFloor)
	//{
	//	// fobO̒lݒ
	//	mPFloor->SetClipCenterTilePoint(mClipCenterTilePoint);
	//	mPFloor->Update(delta);
	//}
}

/// `
void DSMap::Render()
{
	// ̕`揈
	SequenceBase::Render();

	// @mMVCς̂ŕsvɂȂ܂B
	//// tA̕`
	//if (mPFloor)
	//{
	//	mPFloor->SetCamera(mPCamera);
	//	mPFloor->Render();
	//}

	//// Obh̕`
	//mPGrid->Render();
}
