#include "NextMassManager.h"

using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
NextMassManager::NextMassManager()
{
}

/// fXgN^
NextMassManager::~NextMassManager()
{
}

/// lNXg}Xǉ
void NextMassManager::AddNextMass(SP<SData> value)
{
	mNextMasses.push_back(value);
}

/// lNXg}XO
void NextMassManager::RemoveNextMass(SP<SData> value)
{
	mNextMasses.remove(value);
}

/// lNXg}XSďO
void NextMassManager::Clear()
{
	mNextMasses.clear();
}

/// ObḧʒuɃACe邩ǂ擾
bool NextMassManager::IsExistNextMass(const Point& kRGridPosition) const
{
	NextMassList::const_iterator kIt;
	for (kIt = mNextMasses.begin(); kIt != mNextMasses.end(); ++kIt)
	{
		if ((*kIt)->mGridPosition == kRGridPosition)
		{
			return true;
		}
	}

	return false;
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// lNXg}X̃Xg擾
const NextMassManager::NextMassList& NextMassManager::GetNextMassList() const
{
	return mNextMasses;
}