#ifndef MAPDATAMANAGER_H
#define MAPDATAMANAGER_H

#include "Blast/Design/Singleton.h"

#include "ChipTag.h"
#include "ChipKindTag.h"
#include "ChipsetTag.h"
#include "TerrainTag.h"

#include "EnemyChipTag.h"
#include "EnemyChipsetTag.h"


/// }bv֘ȀǗNX
class MapDataManager
	: public Blast::Design::Singleton<MapDataManager>
{
public:
	//====================================================================================================
	// Static
	//----------------------------------------------------------------------------------------------------

	/// `bvZbgێł`bvz̗vf
	static const int MAX_CHIPSET_CHIP_COUNT = 4;

	/// ^C̑
	static const int MAX_TILE_TOTAL_COUNT = 100;

	/// ^C̐̐
	static const int MAX_TILE_HORIZON_COUNT = 10;

	/// ^C̐̐
	static const int MAX_TILE_VERTICAL_COUNT = MAX_TILE_TOTAL_COUNT / MAX_TILE_HORIZON_COUNT;

	/// G̃`bvZbgێł`bv̐
	static const int MAX_ENMEY_CHIP_COUNT = 5;


	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// `bv
	struct SChipData
	{
	public:
		ChipTag::EChipTag			mEChipTag;			///< `bṽ^O
		ChipKindTag::EChipKindTag 	mEChipKindTag;		///< `bv̎ރ^O
		const TCHAR* const			mPModelFilePath;	///< ft@CpX
	};

	/// `bvZbg
	struct SChipsetData
	{
	public:
		ChipsetTag::EChipsetTag mEChipsetTag;						///< `bvZbg̃^O
		ChipTag::EChipTag		mEChipTags[MAX_CHIPSET_CHIP_COUNT];	///< `bv^Oz
	};

	/// tA
	struct SFloorPlacementData
	{
	public:
		TerrainTag::ETerrainTag			mEFloorTag;							/// tA̎
		ChipsetTag::EChipsetTag		mChipsetID;							/// `bvZbg̃^O
		int							mChipIndices[MAX_TILE_TOTAL_COUNT];	/// `bvZbg̎QƐz
	};

	/// G̃`bv
	struct SEnemyChipData
	{
	public:
		EnemyChipTag::EChipTag	mEChipTag;			///< G̃`bv^O
		const TCHAR* const		mPModelFilePath;	///< ft@CpX
	};

	/// G̃`bvZbg
	struct SEnemyChipsetData
	{
	public:
		EnemyChipsetTag::EChipsetTag	mEChipsetTag;						///< G̃`bvZbg^O
		EnemyChipTag::EChipTag			mEChipTags[MAX_ENMEY_CHIP_COUNT];	///< G̃`bvz
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	MapDataManager();

	/// fXgN^
	virtual ~MapDataManager();


	/// `bv擾
	const SChipData& GetChipData(ChipTag::EChipTag) const;

	/// `bvZbg擾
	const SChipsetData& GetChipsetData(ChipsetTag::EChipsetTag) const;

	/// tA擾
	const SFloorPlacementData& GetFloorPlacementData(TerrainTag::ETerrainTag) const;

	/// G̃`bv擾
	const SEnemyChipData& GetEnemyChipData(EnemyChipTag::EChipTag eEnemyChipTag) const;

	/// G̃`bvZbg擾
	const SEnemyChipsetData& GetEnemyChipsetData(EnemyChipsetTag::EChipsetTag eEnemyChipsetTag) const;

private:
};

#endif // MAPDATAMANAGER_H