#include "MainMenuStateDescription.h"

#include "Blast/Input/PadInputTag.h"
#include "./Sequence/MainMenuSequence.h"
#include "MainMenuStateController.h"

using namespace Blast::Input;
using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuStateDescription::MainMenuStateDescription(MainMenuStateController* pStateController)
	: mPStateController(pStateController)
{
	// tgGh
	GetDataManager()->GetFEDescription()->SetHandleInput(true);
	GetDataManager()->GetFEDescription()->SetVisible(true);

	// UNDONE:ɕ\铹ݒ
	const int kItemTag = GetDataManager()->GetFEItem()->GetSelectedItemTag();
	GetDataManager()->GetFEDescription()->SetItem(kItemTag);
}

/// fXgN^
MainMenuStateDescription::~MainMenuStateDescription()
{
}

/// 
void MainMenuStateDescription::HandleInput(float delta)
{
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();
	IMouse* pMouse = InputManagerHelper::GetMouse();
	if (pKB->IsJustDown(Keys::eKEY_X) ||
		pMouse->IsJustDown(Buttons::eBUTTON_RIGHT))
	{
		// sI֖߂
		GetDataManager()->GetFEDescription()->SetHandleInput(false);
		GetDataManager()->GetFEDescription()->SetVisible(false);
		mPStateController->ChangeState(MainMenuStateController::eSTATE_CONDUCT);
	}
}

/// XV
void MainMenuStateDescription::Update(float delta)
{
}

/// `
void MainMenuStateDescription::Render()
{
	DP(10, 10, 0xffffffff, _T("MainMenuStateDescriptionB"));
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainMenuDataManager> MainMenuStateDescription::GetDataManager()
{
	return mPStateController->GetSequence()->GetDataManager();
}