#include "MainMenuStateController.h"

#include "./Sequence/MainMenuSequence.h"
#include "MainMenuStateTop.h"
#include "MainMenuStateItem.h"
#include "MainMenuStateConduct.h"
#include "MainMenuStateDescription.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuStateController::MainMenuStateController(MainMenuSequence* pSeq)
	: mPSequence(pSeq)
{
	// ̏Ԃݒ
	SP<MainMenuStateTop> pState(NEW MainMenuStateTop(this));
	mPCurrentState = pState;
}

/// fXgN^
MainMenuStateController::~MainMenuStateController()
{
}

/// 
void MainMenuStateController::HandleInput(float delta)
{
	// ݂̏Ԃ̓
	if (mPCurrentState)
	{
		mPCurrentState->HandleInput(delta);
	}
}

/// XV
void MainMenuStateController::Update(float delta)
{
	// ݂̏Ԃ̍XV
	if (mPCurrentState)
	{
		mPCurrentState->Update(delta);
	}
}

/// `
void MainMenuStateController::Render()
{
	// ʏԂ̕`
	if (mPCurrentState)
	{
		mPCurrentState->Render();
	}
}

/// ԂύX
void MainMenuStateController::ChangeState(SP<IMainMenuState> pState)
{
	mPPreState = mPCurrentState;
	mPCurrentState = pState;
}

/// ԂύX
void MainMenuStateController::ChangeState(EState eState)
{
	SP<IMainMenuState> pState;
	switch (eState)
	{
		case eSTATE_TOP:			pState.SetPointer(NEW MainMenuStateTop(this));			break;
		case eSTATE_ITEM:			pState.SetPointer(NEW MainMenuStateItem(this));			break;
		case eSTATE_CONDUCT:		pState.SetPointer(NEW MainMenuStateConduct(this));		break;
		case eSTATE_STEP:			// TODO:Xe[g쐬	break;
		case eSTATE_OPTION:			// TODO:Xe[g쐬	break;
		case eSTATE_DESCRIPTION:	pState.SetPointer(NEW MainMenuStateDescription(this));	break;
		default:	break;
	}
	ASSERT_PF(pState, _T("ύX̏Ԃ݂Ă܂B\neState=%d"), eState);

	if (pState)
	{
		ChangeState(pState);
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// V[PX擾
MainMenuSequence* MainMenuStateController::GetSequence()
{
	return mPSequence;
}
