#include "MainMenuFEDescription.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "ItemDatabase.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// ̕\ʒu
	const Vector3 nKNamePosition(100, 200, 0);
	
	/// r̕\ʒu
	const Vector3 nKRubyPosition(100, 200 + 36, 0);

	/// ̕\ʒu
	const Vector3 nKDescriptionPosition(100, 300, 0);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuFEDescription::MainMenuFEDescription()
	: mPCamera(NULL)
	, mPFont(NULL)
	, mPWindow(NULL)
	, mItemNameStr(_T("Missing"))
	, mItemNameRuby(_T("Missing"))
	, mItemDescriptionStr(_T("Missing"))
	, mIsHandleInput(true)
	, mIsEnable(true)
	, mIsVisible(true)
{
	// 2DJZbgAbv
	mPCamera.SetPointer(NEW Camera2D());
	
	// tHg쐬
	mPFont.SetPointer(NEW SpriteFontDX9(_T("HGS޼E"), 32));
	mPFont->SetCamera(mPCamera);

	// EBhE쐬
	mPWindow.SetPointer(NEW SpriteDX9());
	mPWindow->SetCamera(mPCamera);

	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<FileTexture2DDX9> pTex = pRM->Load<FileTexture2DDX9>(_T("./Res/Sprite/Window/ItemWindowDescription.png"));
	mPWindow->SetTexture(pTex);
	mPWindow->FitTextureSize();

	const Vector3 kLeftUpPosition(64, 128, 0);
	Vector3 pos = kLeftUpPosition;
	mPWindow->SetPosition(pos);

	mPWindow->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);
}

/// fXgN^
MainMenuFEDescription::~MainMenuFEDescription() { }


/// 
void MainMenuFEDescription::HandleInput(float delta)
{
}

/// XV
void MainMenuFEDescription::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// J̍XV
	mPCamera->Update(delta);

	// EBhE̍XV
	if (mPWindow)
	{
		mPWindow->Update(delta);
	}
}

/// `
void MainMenuFEDescription::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// EBhE̕`
	if (mPWindow)
	{
		mPWindow->Render();
	}

	// O
	mPFont->SetPosition(nKNamePosition);
	mPFont->SetText(mItemNameStr.c_str());
	mPFont->SetColor(Color(ColorCode::ToCode(ColorCode::eCOLOR_YELLOW)));
	mPFont->Render();

	// r
	mPFont->SetPosition(nKRubyPosition);
	mPFont->SetText(mItemNameRuby.c_str());
	mPFont->SetColor(Color(ColorCode::ToCode(ColorCode::eCOLOR_WHITE)));
	mPFont->Render();

	// 
	mPFont->SetPosition(nKDescriptionPosition);
	mPFont->SetText(mItemDescriptionStr.c_str());
	mPFont->SetColor(Color(ColorCode::ToCode(ColorCode::eCOLOR_WHITE)));
	mPFont->Render();


	// fobO\
	DP(10, 300, 0xffffffff, _T("O:%s\nr:%s\n:%s"),
		mItemNameStr.c_str(),
		mItemNameRuby.c_str(),
		mItemDescriptionStr.c_str());
}


/// \铹ݒ肷
void MainMenuFEDescription::SetItem(int id)
{

	// UNDONE:̏擾
	ItemDatabase* pIDB = ItemDatabase::GetInstance();
	const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt(id);
	ASSERT_PF(kPCatalog, _T("̃J^O擾ł܂łB\nid=%d"), id);
	if (kPCatalog)
	{
		mItemNameStr = kPCatalog->mName;
		mItemNameRuby = kPCatalog->mRuby;
		mItemDescriptionStr = kPCatalog->mDescription;
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ̓tO擾
bool MainMenuFEDescription::IsHandleInput() const
{
	return mIsHandleInput;
}

/// ̓tOݒ
void MainMenuFEDescription::SetHandleInput(bool value)
{
	mIsHandleInput = value;
}

/// XVtO擾
bool MainMenuFEDescription::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void MainMenuFEDescription::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool MainMenuFEDescription::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void MainMenuFEDescription::SetVisible(bool value)
{
	mIsVisible = value;
}