#include "MainGameViewManager.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainGameViewManager::MainGameViewManager(MainGameSequence* pSequence)
	: mPSequence(pSequence)
{
	mPViewTerrain.SetPointer(NEW ViewTerrain(this));
	mPViewUnit.SetPointer(NEW ViewUnit(this));
	mPViewDropItem.SetPointer(NEW ViewDropItem(this));
	mPViewTrap.SetPointer(NEW ViewTrap(this));
	mPViewNextMass.SetPointer(NEW ViewNextMass(this));
}

/// fXgN^
MainGameViewManager::~MainGameViewManager()
{
}

/// XV
void MainGameViewManager::Update(float delta)
{
	mPViewUnit->Update(delta);
	mPViewTrap->Update(delta);
}

/// `
void MainGameViewManager::Render()
{
	mPViewTerrain->Render();
	mPViewUnit->Render();
	mPViewDropItem->Render();
	mPViewTrap->Render();
	mPViewNextMass->Render();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// V[PX擾
MainGameSequence* MainGameViewManager::GetSequence()
{
	return mPSequence;
}

/// n`̕`@\擾
SP<ViewTerrain>	MainGameViewManager::GetViewTerrain()
{
	return mPViewTerrain;
}

/// ̕`@\擾
SP<ViewUnit> MainGameViewManager::GetViewUnit()
{
	return mPViewUnit;
}

/// ̕`@\擾
SP<ViewDropItem> MainGameViewManager::GetViewDropItem()
{
	return mPViewDropItem;
}

/// 㩂̕`@\擾
SP<ViewTrap> MainGameViewManager::GetViewTrap()
{
	return mPViewTrap;
}

/// lNXg}X̕`@\擾
SP<ViewNextMass> MainGameViewManager::GetViewNextMass()
{
	return mPViewNextMass;
}
