#include "MainGameStateNormal.h"

#include "./Sequence/MainGameSequence.h"
#include "MainGameStateController.h"

#include "./Sequence/MainMenuSequence.h"
#include "ItemDatabase.h"

using namespace Blast::Base;
using namespace Blast::Design;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainGameStateNormal::MainGameStateNormal(MainGameStateController* pStateController)
	: mPStateController(pStateController)
	, mPModeTransistor(NEW ModeTransistor<MainGameStateNormal>())
{
	// `Ԃ\z
	mPModeTransistor->Initialize(this);
	mPModeTransistor->Add(
		eMODE_IDLE,
		&MainGameStateNormal::OnIdle,
		NULL,
		&MainGameStateNormal::HandleInputIdle,
		&MainGameStateNormal::UpdateIdle,
		NULL);
	mPModeTransistor->Add(
		eMODE_MOVE,
		&MainGameStateNormal::OnMove,
		NULL,
		NULL,
		&MainGameStateNormal::UpdateMove,
		NULL);
	mPModeTransistor->Add(
		eMODE_NEXT_FLOOR,
		&MainGameStateNormal::OnNextFloor,
		NULL,
		&MainGameStateNormal::HandleInputNextFloor,
		NULL,
		&MainGameStateNormal::RenderNextFloor);
	mPModeTransistor->ChangeMode(eMODE_IDLE);
}

/// fXgN^
MainGameStateNormal::~MainGameStateNormal()
{
}

/// 
void MainGameStateNormal::HandleInput(float delta)
{
	// `Ԃ̓͏
	mPModeTransistor->HandleInput(delta);
}

/// XV
void MainGameStateNormal::Update(float delta)
{
	// `Ԃ̓͏
	mPModeTransistor->Update(delta);

	// eXV
#if _DEBUG
	mPStateController->GetDataManager()->GetXYZAxis()->Update(delta);
	mPStateController->GetDataManager()->GetGrid()->Update(delta);
#endif // _DEBUG
	mPStateController->GetDataManager()->GetCamera()->Update(delta);
	mPStateController->GetDataManager()->GetPlayer()->Update(delta);

	mPStateController->GetDataManager()->GetUnitManager()->Update(delta);
}

/// `
void MainGameStateNormal::Render()
{
	// `Ԃ̕`揈
	mPModeTransistor->Render();

	// e`
#if _DEBUG
	mPStateController->GetDataManager()->GetXYZAxis()->Render();
	mPStateController->GetDataManager()->GetGrid()->Render();
#endif // _DEBUG
}


//====================================================================================================
// MODE
//----------------------------------------------------------------------------------------------------

/* ͑ҋ@ */

/// Jn
void MainGameStateNormal::OnIdle()
{

}

/// 
void MainGameStateNormal::HandleInputIdle(float deltaTime)
{
	// Kvȕϐ񂶂Ď擾
	MainGameSequence* pSeq = mPStateController->GetSequence();
	SP<NextFloorTile> pNextFloorTile = pSeq->GetNextFloorTile();
	std::list< SP<DropItem> >* pDropItems = mPStateController->GetDataManager()->GetDropItems();
	std::list< SP<FloorTrap> >* pTraps = mPStateController->GetDataManager()->GetFloorTraps();
	SP<Character> pPlayer = mPStateController->GetDataManager()->GetPlayer();
	SP<Character> pEnemy = pSeq->GetEnemy();

	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// UNDONE:͎Ńj[J
	if (pKB->IsJustDown(Keys::eKEY_X))
	{
		SP<MainMenuSequence> pMainMenuSeq(NEW MainMenuSequence(true));

		SequenceManager* pSeq = SequenceManager::GetInstance();
		pSeq->AddSequence(pMainMenuSeq);

		return;
	}

	// UNDONE:͎ōUB{ȂʂStateȂB
	if (pKB->IsJustDown(Keys::eKEY_Z))
	{
		// ʕ̈ʒu擾
		const Point& kRPoint = pPlayer->GetTilePoint();

		Point deltaPoint;
		pPlayer->GetDirection().GetCoordinate2D(&deltaPoint);

		Point tgtPoint = kRPoint + deltaPoint;

		// ̈ʒuɓGȂ瑦HP0ɂB
		if (tgtPoint == pEnemy->GetTilePoint())
		{
			pEnemy->GetParameter().mHP = 0;
			PFL(_T("GUB"));
		}
	}

	// ͎ŃvC[LN^[̈ʒuύX
	Point deltaPoint;
	Direction dir;
	if (pKB->IsJustDown(Keys::eKEY_NUMPAD1))
	{
		deltaPoint.mX = -1;
		deltaPoint.mY = 1;
		dir.SetDirection(Direction::eDIRECTION_1);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD2) ||
		pKB->IsJustDown(Keys::eKEY_DOWN))
	{
		deltaPoint.mY = 1;
		dir.SetDirection(Direction::eDIRECTION_2);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD3))
	{
		deltaPoint.mX = 1;
		deltaPoint.mY = 1;
		dir.SetDirection(Direction::eDIRECTION_3);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD4) ||
		pKB->IsJustDown(Keys::eKEY_LEFT))
	{
		deltaPoint.mX = -1;
		dir.SetDirection(Direction::eDIRECTION_4);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD5))
	{
		// Ȃ
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD6) ||
		pKB->IsJustDown(Keys::eKEY_RIGHT))
	{
		deltaPoint.mX = 1;
		dir.SetDirection(Direction::eDIRECTION_6);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD7))
	{
		deltaPoint.mX = -1;
		deltaPoint.mY = -1;
		dir.SetDirection(Direction::eDIRECTION_7);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD8) ||
		pKB->IsJustDown(Keys::eKEY_UP))
	{
		deltaPoint.mY = -1;
		dir.SetDirection(Direction::eDIRECTION_8);
	}
	else if (pKB->IsJustDown(Keys::eKEY_NUMPAD9))
	{
		deltaPoint.mX = 1;
		deltaPoint.mY = -1;
		dir.SetDirection(Direction::eDIRECTION_9);
	}

	if (0 < deltaPoint.SquareLength())
	{
		SP<Unit> pPlayerUnit = mPStateController->GetDataManager()->GetUnitManager()->GetPlayerUnit();
		pPlayerUnit->Move(deltaPoint);
		mPModeTransistor->ChangeMode(eMODE_MOVE);
	}

	// TerrainNX͍폜A͌XKvɂȂ̂ŃɎcĂ
	//if (deltaPoint.mX != 0 || deltaPoint.mY != 0)
	//{
	//	Point tgtPoint = pPlayer->GetTilePoint() + deltaPoint;
	//	const int kTgtTileIndex = tgtPoint.mX + MapDataManager::MAX_TILE_HORIZON_COUNT * tgtPoint.mY;
	//	SP<Tile> pTgtTile = pTerrain->GetTile(kTgtTileIndex);

	//	// vC[͒ʏAړ悪^CvłȂƈړłȂ
	//	SP<Chip> pChip = pTerrain->GetChipset()->GetChip(pTgtTile->GetChipIndex());
	//	if (pChip->GetKindTag() == ChipKindTag::eCHIP_KIND_LAND)
	//	{
	//		pPlayer->SetTilePoint(tgtPoint);

	//		// ʒu
	//		const Vector3& kRWorldPos = pTgtTile->GetWorldPosition();
	//		pPlayer->GetModel()->SetPosition(kRWorldPos);

	//		// ]
	//		float rot = dir.GetRotation();
	//		pPlayer->ChangeDirection(dir.GetDirection());
	//		pPlayer->GetModel()->SetRotation(Vector3::UnitY() * rot);
	//		
	//		// ړ̔B̃tAA㩁AACeȂǂȂǂ邪A܂͊Ki
	//		if (pNextFloorTile->GetTilePosition() == pPlayer->GetTilePoint())
	//		{
	//			// `ԑJ
	//			mPModeTransistor->ChangeMode(eMODE_NEXT_FLOOR);
	//		}

	//		// UNDONE:ACe擾BȂƂAɏ͖̏B
	//		for (int i = 0; i < int(pDropItems->size()); ++i)
	//		{
	//			std::list< SP<DropItem> >::iterator it = pDropItems->begin();
	//			std::advance(it, i);
	//			if (pTgtTile->GetTilePosition() == (*it)->GetTilePosition())
	//			{
	//				// UNDONE:CX^XOBQƐ̃f[^̎QƐύXB
	//				ItemDatabase* pIDB = ItemDatabase::GetInstance();
	//				const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt( (*it)->GetItemID() );
	//				const int kChipIndex = kPCatalog->mKindID;

	//				// CX^VÕf̏OsĂӏB
	//				//SP<StaticModelDX9> pModel = pDropItemChipset->GetChip(kChipIndex)->GetModel();
	//				//const int kInstanceIndex = (*it)->GetInstanceIndex();
	//				//pModel->RemoveInstance( kInstanceIndex, 1 );

	//				Possession::GetInstance()->Obtain( (*it)->GetItemID() );
	//				pDropItems->erase(it);
	//				
	//				// HACK:폜ċ󂢂̃CX^X̃CfbNXl߂BfQƂĂ̂̂ݏB
	//				int count = 0;
	//				for (int j = 0; j < int(pDropItems->size()); ++j)
	//				{
	//					std::list< SP<DropItem> >::iterator it = pDropItems->begin();
	//					std::advance(it, j);

	//					if (kChipIndex == pIDB->GetCatalogAt( (*it)->GetItemID() )->mKindID)
	//					{
	//						(*it)->SetInstanceIndex(count);
	//						++count;
	//					}
	//				}

	//				// Ȃ炷break
	//				break;
	//			}
	//		}

	//		// UNDONE:㩔B炭͕̏ʂStateɔCׂȂB
	//		std::list< SP<FloorTrap> >::iterator it2 = pTraps->begin();
	//		for (it2 = pTraps->begin(); it2 != pTraps->end(); ++it2)
	//		{
	//			if (pTgtTile->GetTilePosition() == (*it2)->GetTilePosition())
	//			{
	//				// 㩂Ƃ̏͂
	//				PFL(_T("㩂𓥂݂܂BTrapID=%d"), (*it2)->GetTrapID());
	//				break;
	//			}
	//		}
	//	}
	//}

	// J̓͏
	mPStateController->GetSequence()->GetDataManager()->GetCamera()->HandleInput(deltaTime);
}

/// XV
void MainGameStateNormal::UpdateIdle(float deltaTime)
{
}


/* ړ */

///< Jn
void MainGameStateNormal::OnMove()
{
}

///< XV
void MainGameStateNormal::UpdateMove(float deltaTime)
{
	SP<Unit> pUnitPlayer = mPStateController->GetDataManager()->GetUnitManager()->GetPlayerUnit();
	if (pUnitPlayer)
	{
		// ړIǂm
		if (!pUnitPlayer->IsMoving())
		{
			// ͉Ȃ悤ɂĂ邪A{͈ړ̃}XŁAEA㩂AlNXg}X̏KvB
			mPModeTransistor->ChangeMode(eMODE_IDLE);
		}
	}
}


/* ̃tA֐iނǂ */

/// Jn
void MainGameStateNormal::OnNextFloor()
{
}

/// 
void MainGameStateNormal::HandleInputNextFloor(float deltaTime)
{
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// ZXŌ肷
	if (pKB->IsJustDown(Keys::eKEY_Z))
	{
		// ꂪ{̏AtAȂǂ̐ݒ肪Kv
		mPStateController->ChangeState(MainGameStateController::eSTATE_CONSTRUCT);
	}
	else if (pKB->IsJustDown(Keys::eKEY_X))
	{
		//mIsSelectingNextFloor = false;
		mPModeTransistor->ChangeMode(eMODE_IDLE);
	}
}

/// `
void MainGameStateNormal::RenderNextFloor()
{
	DP(10, 50, 0xffffffff, _T("Z:\nX:̂܂"));
}