#include "MainGameStateController.h"

#include "./Sequence/MainGameSequence.h"
#include "MainGameStateConstruct.h"
#include "MainGameStateNormal.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainGameStateController::MainGameStateController(MainGameSequence* pSeq)
	: mPSequence(pSeq)
{
	// ̏Ԃݒ
	SP<MainGameStateConstruct> pState(NEW MainGameStateConstruct(this));
	mPCurrentState = pState;
}

/// fXgN^
MainGameStateController::~MainGameStateController()
{
}

/// 
void MainGameStateController::HandleInput(float delta)
{
	// ݂̏Ԃ̓
	if (mPCurrentState)
	{
		mPCurrentState->HandleInput(delta);
	}
}

/// XV
void MainGameStateController::Update(float delta)
{
	// ݂̏Ԃ̍XV
	if (mPCurrentState)
	{
		mPCurrentState->Update(delta);
	}
}

/// `
void MainGameStateController::Render()
{
	// ʏԂ̕`
	if (mPCurrentState)
	{
		mPCurrentState->Render();
	}
}

/// V[PX擾
MainGameSequence* MainGameStateController::GetSequence()
{
	return mPSequence;
}

/// Ǘ擾
SP<MainGameDataManager> MainGameStateController::GetDataManager()
{
	return mPSequence->GetDataManager();
}


/// ԂύX
void MainGameStateController::ChangeState(SP<IMainGameState> pState)
{
	mPCurrentState = pState;
}

/// ԂύX
void MainGameStateController::ChangeState(EState eState)
{
	SP<IMainGameState> pState;
	switch (eState)
	{
		case eSTATE_CONSTRUCT:
			pState.SetPointer(NEW MainGameStateConstruct(this));
			break;

		case eSTATE_NORMAL:
			pState.SetPointer(NEW MainGameStateNormal(this));
			break;

		case eSTATE_MAINMENU:
			HALT(_T("łB"));
			break;
	}

	ASSERT_PF(pState, _T("NULLState肵悤Ƃ܂B"));
	mPPreState = mPCurrentState;
	mPCurrentState = pState;
}
