#include "ItemCSV.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"
#include "Blast/IO/CSVRecord.h"

#include "ItemTag.h"
#include "ItemCommandTag.h"

#include "TagConverter.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ItemCSV::ItemCSV()
{
	// ACe̊{̃t@C܂ĂȂ̂ňUCO
	//Reload();
}

/// fXgN^
ItemCSV::~ItemCSV()
{
}

/// ēǂݍ
void ItemCSV::Reload()
{
	LoadBaseData();
	// ADD:ɒǉĂB
}

/// {Q擾
const SP<ItemCSV::SBase> ItemCSV::GetBaseDatas() const
{
	return mSBaseDatas;
}
/// {擾
const ItemCSV::SBase* ItemCSV::GetBaseData(ItemTag::EItemTag eTag) const
{
	return &mSBaseDatas[eTag];
}


//====================================================================================================
// Imeplement
//----------------------------------------------------------------------------------------------------

/// {̓ǂݍ
void ItemCSV::LoadBaseData()
{
	// CSVt@CWJ
	CSVFile csv(_T("./Res/DB/Item/ItemBase.bin"));
	bool isCSVOk = csv.Create();
	if (!isCSVOk)
	{
		return;
	}

	// CSVt@C̏𔲐
	const SP<CSVTable> pDT = csv.GetDataTable();
	const int kRecordCount = pDT->GetRecordCount();

	mSBaseDatas.SetPointer(NEW SBase[kRecordCount], true);
	for (int i = 0; i < kRecordCount; ++i)
	{
		const SP<CSVRecord> kPRecord = pDT->GetRecord(i);

		SBase* pDst = &mSBaseDatas[i];
		pDst->mID				= kPRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pDst->mEItemTag			= TagConverter::ToItemTag( kPRecord->GetItem(_T("^O"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mName, SIZE_OF_ARRAY(pDst->mName), kPRecord->GetItem(_T("O"))->GetValueRef().ToCharacter() );
		for (int i = 0; i < SIZE_OF_ARRAY(pDst->mItemCommandTags); ++i)
		{
			TCHAR tgtColumnName[32] = { '\0' };
			_stprintf_s(tgtColumnName, SIZE_OF_ARRAY(tgtColumnName), _T("R}h%d"), i);
			pDst->mItemCommandTags[i] = TagConverter::ToItemCommandTag( kPRecord->GetItem(tgtColumnName)->GetValueRef().ToCharacter() );
		}
		_tcscpy_s( pDst->mDiscription, SIZE_OF_ARRAY(pDst->mDiscription), kPRecord->GetItem(_T(""))->GetValueRef().ToCharacter() );
	}
}