#include "GamePad.h"

using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
GamePad::GamePad()
{
	// eC^[tF[XfoCX擾
	mPMouse = InputManagerHelper::GetMouse();
	mPKeyboard = InputManagerHelper::GetKeyboard();
	mPJoystick = InputManagerHelper::GetJoystick();
}

/// fXgN^
GamePad::~GamePad()
{
}


/// UNDONE:́BL[ATC񂩂̎擾܂B
void GamePad::HandleInputs(float delta)
{
}

/// ͂ꂽǂ擾
bool GamePad::IsInput(EStrategy eStrategy) const
{
	bool isInput = false;
	switch (eStrategy)
	{
		case eSTRATEGY_OK:
			// B
			// M:NbN
			// K:EnterL[AZL[
			// J:{^0
			isInput |= mPMouse->IsJustDown(Buttons::eBUTTON_LEFT);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_Z);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_RETURN);
			isInput |= mPJoystick->IsJustDown(Buttons::eBUTTON_0);
			break;

		case eSTRATEGY_CANCEL:
			// LZB
			// M:ENbN
			// K:BackspaceL[AXL[
			// J:{^1
			isInput |= mPMouse->IsJustDown(Buttons::eBUTTON_RIGHT);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_X);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_BACK);
			isInput |= mPJoystick->IsJustDown(Buttons::eBUTTON_1);
			break;

		case eSTRATEGY_MENU:
			// j[J̓͂sB
			// M:{^3
			// K:FL[
			// J:{^2
			isInput |= mPMouse->IsJustDown(Buttons::eBUTTON_3);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_F);
			isInput |= mPJoystick->IsJustDown(Buttons::eBUTTON_2);
			break;

		case eSTRATEGY_TURN:
			// UȂǂ̓́B
			// M:{^4
			// K:CL[
			// J:{^3
			isInput |= mPMouse->IsJustDown(Buttons::eBUTTON_4);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_C);
			isInput |= mPJoystick->IsJustDown(Buttons::eBUTTON_3);
			break;

		case eSTRATEGY_MOVE_UP:
			// ֘A̓͂sB
			// M:zC[Abv
			// K:WL[AA[L[
			// J:{^
			isInput |= mPMouse->IsWheelUp();
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_W);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_UP);
			isInput |= mPJoystick->IsJustDownPOV(PointOfViews::ePOINT_OF_VIEW_UP, PointOfViews::ePOINT_OF_VIEW_UP);
			break;

		case eSTRATEGY_MOVE_DOWN:
			// ֘A̓͂sB
			// M:zC[_E
			// K:SL[AA[L[
			// J:{^
			isInput |= mPMouse->IsWheelDown();
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_S);
			isInput |= mPKeyboard->IsJustDown(Keys::eKEY_DOWN);
			isInput |= mPJoystick->IsJustDownPOV(PointOfViews::ePOINT_OF_VIEW_DOWN, PointOfViews::ePOINT_OF_VIEW_DOWN);
			break;

		default:
			break;
	}

	return isInput;
}
