#include "FloorPlacementTrapData.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FloorPlacementTrapData::FloorPlacementTrapData() :
mTrapID(-1),
mTilePosition(-1),
mIsDiscovery(false)
{
}

/// fXgN^
FloorPlacementTrapData::~FloorPlacementTrapData()
{
}


/// ID擾
int FloorPlacementTrapData::GetID() const
{
	return mTrapID;
}


/// ǂݍ
void FloorPlacementTrapData::Load(const SP<CSVRecord> kPRecord)
{
	mTrapID = kPRecord->GetItem(_T("TrapID"))->GetValueRef().ToInteger();
	mTilePosition.mX = kPRecord->GetItem(_T("X"))->GetValueRef().ToInteger();
	mTilePosition.mY = kPRecord->GetItem(_T("Y"))->GetValueRef().ToInteger();
	mIsDiscovery = kPRecord->GetItem(_T(""))->GetValueRef().ToBoolean();
}