#ifndef FLOORDATABASE_H
#define FLOORDATABASE_H

#include <map>
#include <vector>
#include <list>
#include "Blast/Design/Singleton.h"
#include "FloorConsititutionData.h"
#include "FloorPlacementData.h"
#include "FloorRoomData.h"
#include "FloorPlacementItemDataTable.h"
#include "FloorPlacementItemRandDataTable.h"
#include "FloorPlacementTrapDataTable.h"
#include "FloorPlacementEnemyDataTable.h"
#include "FloorPlacementNPCDataTable.h"
#include "FloorKindData.h"


/// tÅOf[^x[XSNX
class FloorDatabase :
	public Blast::Design::Singleton<FloorDatabase>
{
public:
	//====================================================================================================
	// Alias
	//----------------------------------------------------------------------------------------------------

	/// MEMO:map̕ł傤B

	/// ̃_zũf[^e[ũXg
	typedef std::list< SP<FloorPlacementItemRandDataTable> > FloorPlacementItemRandDataTableList;


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	FloorDatabase();

	/// fXgN^
	virtual ~FloorDatabase();


	/// zuf[^ǂݍ
	void LoadPlacement(const TCHAR* const kPFullPath);

	/// f[^ǂݍ
	void LoadRoom(const TCHAR* const kPFullPath);

	/// zuf[^ǂݍ
	void LoadPlacementItem(const TCHAR* const kPFullPath);

	/// zuf[^ǂݍ
	void LoadPlacementItemRand(const TCHAR* const kPFullPath);

	/// 㩔zuf[^ǂݍ
	void LoadPlacementTrap(const TCHAR* const kPFullPath);

	/// Gzuf[^ǂݍ
	void LoadPlacementEnemy(const TCHAR* const kPFullPath);

	/// NPCzuf[^ǂݍ
	void LoadPlacementNPC(const TCHAR* const kPFullPath);

	/// \f[^ǂݍ
	void LoadConsititution(const TCHAR* const kPFullPath);

	/// ރf[^ǂݍ
	void LoadKind(const TCHAR* const kPFullPath);


	/// zuf[^擾
	const SP<FloorPlacementData> GetPlacementData(int id) const;

	/// f[^擾
	const SP<FloorRoomData> GetRoomData(int id) const;

	/// zuf[^e[u擾
	const SP<FloorPlacementItemDataTable> GetPlacementItemDataTable(int id) const;

	/// zuf[^e[u擾
	const SP<FloorPlacementItemRandDataTable> GetPlacementItemRandDataTable(int id) const;

	/// 㩔zuf[^e[u擾
	const SP<FloorPlacementTrapDataTable> GetPlacementTrapDataTable(int id) const;

	/// Gzuf[^e[u擾
	const SP<FloorPlacementEnemyDataTable> GetPlacementEnemyDataTable(int id) const;

	/// NPCzuf[^e[u擾
	const SP<FloorPlacementNPCDataTable> GetPlacementNPCDataTable(int id) const;

	/// \f[^擾
	const SP<FloorConsititutionData> GetConsititutionData(int id) const;

	/// ރf[^擾
	const SP<FloorKindData> GetKindData(int id) const;

private:
	/// zuf[^
	std::list< SP<FloorPlacementData> > mPlacementDatas;

	/// f[^
	std::list< SP<FloorRoomData> > mRoomDatas;

	/// zuf[^e[uQ
	std::list< SP<FloorPlacementItemDataTable> > mFloorPlacementItemDataTables;

	/// zuf[^e[uQ
	FloorPlacementItemRandDataTableList mFloorPlacementItemRandDataTables;

	/// 㩔zuf[^e[uQ
	std::list< SP<FloorPlacementTrapDataTable> > mFloorPlacementTrapDataTables;

	/// Gzuf[^e[uQ
	std::list< SP<FloorPlacementEnemyDataTable> > mFloorPlacementEnemyDataTables;

	/// NPCzuf[^e[uQ
	std::list< SP<FloorPlacementNPCDataTable> > mFloorPlacementNPCDataTables;

	/// \f[^
	std::list< SP<FloorConsititutionData> > mConsititutionDatas;

	/// ރf[^
	std::list< SP<FloorKindData> > mKindDatas;
};

#endif // FLOORDATABASE_H