#include "FloorDatabase.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FloorDatabase::FloorDatabase()
{
	// ^Czuǂݍ
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement0.bin"));
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement1.bin"));
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement2.bin"));
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement3.bin"));
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement4.bin"));
	LoadPlacement(_T("./Res/DB/Floor/FloorPlacement5.bin"));

	// zuǂݍ
	LoadRoom(_T("./Res/DB/Floor/FloorRoom0.bin"));
	LoadRoom(_T("./Res/DB/Floor/FloorRoom1.bin"));
	LoadRoom(_T("./Res/DB/Floor/FloorRoom2.bin"));
	LoadRoom(_T("./Res/DB/Floor/FloorRoom3.bin"));
	LoadRoom(_T("./Res/DB/Floor/FloorRoom4.bin"));
	LoadRoom(_T("./Res/DB/Floor/FloorRoom5.bin"));

	// zuǂݍ
	LoadPlacementItem(_T("./Res/DB/Floor/FloorPlacementItem0.bin"));
	LoadPlacementItem(_T("./Res/DB/Floor/FloorPlacementItem1.bin"));
	LoadPlacementItem(_T("./Res/DB/Floor/FloorPlacementItem2.bin"));

	// zuǂݍ
	LoadPlacementItemRand(_T("./Res/DB/Floor/FloorPlacementItemRand0.bin"));
	LoadPlacementItemRand(_T("./Res/DB/Floor/FloorPlacementItemRand1.bin"));

	// 㩔zuǂݍ
	LoadPlacementTrap(_T("./Res/DB/Floor/FloorPlacementTrap0.bin"));
	LoadPlacementTrap(_T("./Res/DB/Floor/FloorPlacementTrap1.bin"));
	LoadPlacementTrap(_T("./Res/DB/Floor/FloorPlacementTrap2.bin"));

	// Gzuǂݍ
	LoadPlacementEnemy(_T("./Res/DB/Floor/FloorPlacementEnemy0.bin"));
	LoadPlacementEnemy(_T("./Res/DB/Floor/FloorPlacementEnemy1.bin"));
	LoadPlacementEnemy(_T("./Res/DB/Floor/FloorPlacementEnemy2.bin"));

	// NPCzuǂݍ
	LoadPlacementNPC(_T("./Res/DB/Floor/FloorPlacementNPC0.bin"));
	LoadPlacementNPC(_T("./Res/DB/Floor/FloorPlacementNPC1.bin"));
	LoadPlacementNPC(_T("./Res/DB/Floor/FloorPlacementNPC2.bin"));

	// \ǂݍ
	LoadConsititution(_T("./Res/DB/Floor/FloorConsititution.bin"));

	// ޏǂݍ
	LoadKind(_T("./Res/DB/Floor/FloorKind.bin"));
}

/// fXgN^
FloorDatabase::~FloorDatabase()
{
}


/// zuf[^ǂݍ
void FloorDatabase::LoadPlacement(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// 񐔂ƍs擾
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	SP<FloorPlacementData> pData(NEW FloorPlacementData(kColumnCount, kRowCount));
	pData->mID = mPlacementDatas.size();


	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// e[ũR[hŃ[v
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		for (int j = 0; j < kColumnCount; ++j)
		{
			// f[^ݒ
			const CSVRecord::SField* kPSField = pRecord->GetItem(j);
			const int kLinearIndex = MathHelper::CalculateLinearIndex(j, i, kColumnCount);

			const int kTileID = kPSField->GetValueRef().ToInteger();
			pData->mTileIDs[kLinearIndex] = kTileID;
		}
	}

	// f[^}bvɒǉ
	mPlacementDatas.push_back(pData);
}

/// f[^ǂݍ
void FloorDatabase::LoadRoom(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// 񐔂ƍs擾
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	const int kTotalCount = kColumnCount * kRowCount;


	// f[^쐬
	SP<FloorRoomData> pData(NEW FloorRoomData());
	pData->mID = mRoomDatas.size();
	pData->mHorizonTileCount = kColumnCount;
	pData->mVerticalTileCount = kRowCount;

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// e[ũR[hŃ[v
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		for (int j = 0; j < kColumnCount; ++j)
		{
			// f[^ݒ
			const CSVRecord::SField* kPSField = pRecord->GetItem(j);

			const int kLinearIndex = MathHelper::CalculateLinearIndex(j, i, kColumnCount);
			const int kRoomID = kPSField->GetValueRef().ToInteger();
			pData->mTileIDs.push_back(kRoomID);
		}
	}

	// f[^}bvɒǉ
	mRoomDatas.push_back(pData);
}

/// zuf[^ǂݍ
void FloorDatabase::LoadPlacementItem(const TCHAR* const kPFullPath)
{
	SP<FloorPlacementItemDataTable> pDataTable(NEW FloorPlacementItemDataTable());
	pDataTable->Load(kPFullPath);

	// ID͂œB
	pDataTable->SetTableID(mFloorPlacementItemDataTables.size());

	mFloorPlacementItemDataTables.push_back(pDataTable);
}

/// zuf[^ǂݍ
void FloorDatabase::LoadPlacementItemRand(const TCHAR* const kPFullPath)
{
	// 쐬
	SP<FloorPlacementItemRandDataTable> pDT(NEW FloorPlacementItemRandDataTable());
	pDT->Load(kPFullPath);

	// IDݒ
	pDT->SetTableID(mFloorPlacementItemRandDataTables.size());

	// }bvɒǉ
	mFloorPlacementItemRandDataTables.push_back(pDT);
}

/// 㩔zuf[^ǂݍ
void FloorDatabase::LoadPlacementTrap(const TCHAR* const kPFullPath)
{
	SP<FloorPlacementTrapDataTable> pDataTable(NEW FloorPlacementTrapDataTable());
	pDataTable->Load(kPFullPath);

	// ID͂œB
	pDataTable->SetTableID(mFloorPlacementTrapDataTables.size());

	mFloorPlacementTrapDataTables.push_back(pDataTable);
}

/// Gzuf[^ǂݍ
void FloorDatabase::LoadPlacementEnemy(const TCHAR* const kPFullPath)
{
	SP<FloorPlacementEnemyDataTable> pDataTable(NEW FloorPlacementEnemyDataTable());
	pDataTable->Load(kPFullPath);

	// ID͂œB
	pDataTable->SetTableID(mFloorPlacementEnemyDataTables.size());

	mFloorPlacementEnemyDataTables.push_back(pDataTable);
}

/// NPCzuf[^ǂݍ
void FloorDatabase::LoadPlacementNPC(const TCHAR* const kPFullPath)
{
	SP<FloorPlacementNPCDataTable> pDataTable(NEW FloorPlacementNPCDataTable());
	pDataTable->Load(kPFullPath);

	// ID͂œB
	pDataTable->SetTableID(mFloorPlacementNPCDataTables.size());

	mFloorPlacementNPCDataTables.push_back(pDataTable);
}

/// \f[^ǂݍ
void FloorDatabase::LoadConsititution(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<FloorConsititutionData> pData(NEW FloorConsititutionData());

		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mETag = i;// pRecord->GetItem(_T("^O"))->GetValueRef().GetValueStrRef();
		pData->mKindID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mPlacementID = pRecord->GetItem(_T("zuID"))->GetValueRef().ToInteger();
		pData->mRoomID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mPlacementItemID = pRecord->GetItem(_T("zuID"))->GetValueRef().ToInteger();
		pData->mPlacementItemMinCount = pRecord->GetItem(_T("ŏ"))->GetValueRef().ToInteger();
		pData->mPlacementItemMaxCount = pRecord->GetItem(_T("ő哹"))->GetValueRef().ToInteger();
		pData->mPlacementItemRandomID = pRecord->GetItem(_T("zuID"))->GetValueRef().ToInteger();
		pData->mPlacementTrapID = pRecord->GetItem(_T("㩔zuID"))->GetValueRef().ToInteger();
		pData->mPlacementEnemyID = pRecord->GetItem(_T("GzuID"))->GetValueRef().ToInteger();
		pData->mPlacementNPCID = pRecord->GetItem(_T("NPCzuID"))->GetValueRef().ToInteger();
		pData->mNextFloorTileX = pRecord->GetItem(_T("X"))->GetValueRef().ToInteger();
		pData->mNextFloorTileY = pRecord->GetItem(_T("Y"))->GetValueRef().ToInteger();
		pData->mNextFloorTileModelFilePath = pRecord->GetItem(_T("ft@CpX"))->GetValueRef().GetValueStrRef();

		mConsititutionDatas.push_back(pData);
	}
}

/// ރf[^ǂݍ
void FloorDatabase::LoadKind(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<FloorKindData> pData(NEW FloorKindData());

		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mNameStr = pRecord->GetItem(_T("O"))->GetValueRef().GetValueStrRef();
		pData->mETag = i;//pRecord->GetItem(_T(""))->GetValueRef().GetValueStrRef();
		pData->mGroundModelPathStr = pRecord->GetItem(_T("fpX"))->GetValueRef().GetValueStrRef();
		pData->mWallModelPathStr = pRecord->GetItem(_T("ǃfpX"))->GetValueRef().GetValueStrRef();
		
		mKindDatas.push_back(pData);
	}
}


/// zuf[^擾
const SP<FloorPlacementData> FloorDatabase::GetPlacementData(int id) const
{
	std::list< SP<FloorPlacementData> >::const_iterator kIt = mPlacementDatas.begin();
	while (kIt != mPlacementDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementData>();
}

/// f[^擾
const SP<FloorRoomData> FloorDatabase::GetRoomData(int id) const
{
	std::list< SP<FloorRoomData> >::const_iterator kIt = mRoomDatas.begin();
	while (kIt != mRoomDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorRoomData>();
}

/// zuf[^擾
const SP<FloorPlacementItemDataTable> FloorDatabase::GetPlacementItemDataTable(int id) const
{
	std::list< SP<FloorPlacementItemDataTable> >::const_iterator kIt = mFloorPlacementItemDataTables.begin();
	while (kIt != mFloorPlacementItemDataTables.end())
	{
		if ((*kIt)->GetTableID() == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementItemDataTable>();
}

/// zuf[^e[u擾
const SP<FloorPlacementItemRandDataTable> FloorDatabase::GetPlacementItemRandDataTable(int id) const
{
	FloorPlacementItemRandDataTableList::const_iterator kIt = mFloorPlacementItemRandDataTables.begin();
	while (kIt != mFloorPlacementItemRandDataTables.end())
	{
		return *kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementItemRandDataTable>();
}

/// 㩔zuf[^e[u擾
const SP<FloorPlacementTrapDataTable> FloorDatabase::GetPlacementTrapDataTable(int id) const
{
	std::list< SP<FloorPlacementTrapDataTable> >::const_iterator kIt = mFloorPlacementTrapDataTables.begin();
	while (kIt != mFloorPlacementTrapDataTables.end())
	{
		if ((*kIt)->GetTableID() == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementTrapDataTable>();
}

/// Gzuf[^e[u擾
const SP<FloorPlacementEnemyDataTable> FloorDatabase::GetPlacementEnemyDataTable(int id) const
{
	std::list< SP<FloorPlacementEnemyDataTable> >::const_iterator kIt = mFloorPlacementEnemyDataTables.begin();
	while (kIt != mFloorPlacementEnemyDataTables.end())
	{
		if ((*kIt)->GetTableID() == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementEnemyDataTable>();
}

/// NPCzuf[^e[u擾
const SP<FloorPlacementNPCDataTable> FloorDatabase::GetPlacementNPCDataTable(int id) const
{
	std::list< SP<FloorPlacementNPCDataTable> >::const_iterator kIt = mFloorPlacementNPCDataTables.begin();
	while (kIt != mFloorPlacementNPCDataTables.end())
	{
		if ((*kIt)->GetTableID() == id)
		{
			return *kIt;
		}

		++kIt;
	}

	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorPlacementNPCDataTable>();
}

/// \f[^擾
const SP<FloorConsititutionData> FloorDatabase::GetConsititutionData(int id) const
{
	std::list< SP<FloorConsititutionData> >::const_iterator kIt = mConsititutionDatas.begin();
	while (kIt != mConsititutionDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorConsititutionData>();
}

/// ރf[^擾
const SP<FloorKindData> FloorDatabase::GetKindData(int id) const
{
	std::list< SP<FloorKindData> >::const_iterator kIt = mKindDatas.begin();
	while (kIt != mKindDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<FloorKindData>();
}