#include "EnemyChipset.h"

#include "MapDataManager.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
EnemyChipset::EnemyChipset()
	: mETag(EnemyChipsetTag::eCHIPSET_INVALID)
{
	// `bvz𓮓Im
	for (int i = 0; i < kMAX_CHIP_COUNT; ++i)
	{
		mPChips[i].SetPointer(NEW EnemyChip());
	}
}

/// fXgN^
EnemyChipset::~EnemyChipset()
{
}

/// 
void EnemyChipset::Initialize(int id)
{
	const MapDataManager::SEnemyChipsetData& kRSData = MapDataManager::GetInstance()->GetEnemyChipsetData(static_cast<EnemyChipsetTag::EChipsetTag>(id));

	// `bvz쐬
	mETag = kRSData.mEChipsetTag;
	for (int i = 0; i < MapDataManager::MAX_CHIPSET_CHIP_COUNT; ++i)
	{
		mPChips[i]->Initialize(kRSData.mEChipTags[i]);
	}
}
