#include "EnemyCSV.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"
#include "Blast/IO/CSVRecord.h"

#include "EnemyTag.h"
#include "RaceTag.h"
#include "AttributeTag.h"
#include "TagConverter.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
EnemyCSV::EnemyCSV()
{
	Reload();
}

/// fXgN^
EnemyCSV::~EnemyCSV()
{
}

/// ēǂݍ
void EnemyCSV::Reload()
{
	LoadBaseData();
	// ADD:ɒǉĂB
}

/// {Q擾
const SP<EnemyCSV::SBase> EnemyCSV::GetBaseDatas() const
{
	return mSBaseDatas;
}
/// {擾
const EnemyCSV::SBase* EnemyCSV::GetBaseData(EnemyTag::EEnemyTag eTag) const
{
	return &mSBaseDatas[eTag];
}


//====================================================================================================
// Imeplement
//----------------------------------------------------------------------------------------------------

/// {̓ǂݍ
void EnemyCSV::LoadBaseData()
{
	// CSVt@CWJ
	CSVFile csv(_T("./Res/DB/Enemy/EnemyBase.bin"));
	bool isCSVOk = csv.Create();
	if (!isCSVOk)
	{
		return;
	}

	// CSVt@C̏𔲐
	const SP<CSVTable> pDT = csv.GetDataTable();
	const int kRecordCount = pDT->GetRecordCount();

	mSBaseDatas.SetPointer(NEW SBase[kRecordCount], true);
	for (int i = 0; i < kRecordCount; ++i)
	{
		const SP<CSVRecord> kPRecord = pDT->GetRecord(i);

		SBase* pDst = &mSBaseDatas[i];
		pDst->mID				= kPRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pDst->mEEnemyTag		= TagConverter::ToEnemyTag( kPRecord->GetItem(_T("^O"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mName, SIZE_OF_ARRAY(pDst->mName), kPRecord->GetItem(_T("O"))->GetValueRef().ToCharacter() );
		pDst->mERaceTag			= TagConverter::ToRaceTag( kPRecord->GetItem(_T("푮^O"))->GetValueRef().ToCharacter() );
		pDst->mEAttributeTag	= TagConverter::ToAttributeTag( kPRecord->GetItem(_T("^O"))->GetValueRef().ToCharacter() );
		_tcscpy_s( pDst->mDiscription, SIZE_OF_ARRAY(pDst->mDiscription), kPRecord->GetItem(_T("O"))->GetValueRef().ToCharacter() );
	}
}