#ifndef DUNGEONDATABASE_H
#define DUNGEONDATABASE_H

#include <list>
#include "Blast/Design/Singleton.h"
#include "DungeonConsititutionData.h"
#include "DungeonGenerationData.h"


/// _W̊Of[^SNX
class DungeonDatabase :
	public Blast::Design::Singleton<DungeonDatabase>
{
public:
	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	DungeonDatabase();

	/// fXgN^
	virtual ~DungeonDatabase();


	/// f[^ǂݍ
	void LoadGeneration(const TCHAR* const kPFullPath);

	/// \f[^ǂݍ
	void LoadConsititution(const TCHAR* const kPFullPath);


	/// f[^擾
	const SP<DungeonGenerationData> GetGenerationData(int id) const;

	/// \f[^擾
	const SP<DungeonConsititutionData> GetConsititutionData(int id) const;

private:
	/// f[^
	std::list< SP<DungeonGenerationData> > mGenerationDatas;

	/// \f[^
	std::list< SP<DungeonConsititutionData> > mConsititutionDatas;
};

#endif // DUNGEONDATABASE_H