#include "DungeonDatabase.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DungeonDatabase::DungeonDatabase()
{
	LoadGeneration(_T("./Res/DB/Dungeon/DungeonGeneration.bin"));
	LoadConsititution(_T("./Res/DB/Dungeon/DungeonConsititution.bin"));
}

/// fXgN^
DungeonDatabase::~DungeonDatabase()
{
}


/// f[^ǂݍ
void DungeonDatabase::LoadGeneration(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<DungeonGenerationData> pData(NEW DungeonGenerationData());

		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mCandidateCount = pRecord->GetItem(_T("␔"))->GetValueRef().ToInteger();

		for (int j = 0; j < pData->mCandidateCount; ++j)
		{
			TCHAR buffer[StringHelper::mStKDefaultBufferSize];
			ZeroMemory(buffer, sizeof(buffer));

			_sntprintf_s(buffer, StringHelper::mStKDefaultBufferSize, _T("\ID%d"), j + 1);

			const int kID = pRecord->GetItem(buffer)->GetValueRef().ToInteger();
			pData->mFloorConsititutionIDs.push_back(kID);
		}
		
		mGenerationDatas.push_back(pData);
	}
}

/// \f[^ǂݍ
void DungeonDatabase::LoadConsititution(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<DungeonConsititutionData> pData(NEW DungeonConsititutionData());

		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mETag = i;//pRecord->GetItem(_T(""))->GetValueRef().GetValueStrRef();
		pData->mNameStr = pRecord->GetItem(_T("O"))->GetValueRef().GetValueStrRef();
		pData->mFloorCount = pRecord->GetItem(_T("Kw"))->GetValueRef().ToInteger();

		for (int j = 0; j < pData->mFloorCount; ++j)
		{
			TCHAR buffer[StringHelper::mStKDefaultBufferSize];
			ZeroMemory(buffer, sizeof(buffer));

			_sntprintf_s(buffer, StringHelper::mStKDefaultBufferSize, _T("%dF"), j + 1);

			const int kID = pRecord->GetItem(buffer)->GetValueRef().ToInteger();
			pData->mGenerationIDs.push_back(kID);
		}
		
		mConsititutionDatas.push_back(pData);
	}
}


/// f[^擾
const SP<DungeonGenerationData> DungeonDatabase::GetGenerationData(int id) const
{
	std::list< SP<DungeonGenerationData> >::const_iterator kIt = mGenerationDatas.begin();
	while (kIt != mGenerationDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<DungeonGenerationData>();
}

/// \f[^擾
const SP<DungeonConsititutionData> DungeonDatabase::GetConsititutionData(int id) const
{
	std::list< SP<DungeonConsititutionData> >::const_iterator kIt = mConsititutionDatas.begin();
	while (kIt != mConsititutionDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<DungeonConsititutionData>();
}