#include "DropItemChipset.h"

#include "ItemCategoryTag.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// fpXBÓIȂ̂łŗpӂĂ邪AK؂ȏꏊ܂炻ɈڍsĂǂB
	const TCHAR* const nKPModelFilePaths[6] =	//< 6͕hƂ`悷铹̎ށBenumx^[B
	{
		_T("./Res/Model/DropItem/Weapon/Mesh.FBX"),
		_T("./Res/Model/DropItem/Shield/Mesh.FBX"),
		_T("./Res/Model/DropItem/Pendant/Mesh.FBX"),
		_T("./Res/Model/DropItem/EXE/Mesh.FBX"),
		_T("./Res/Model/DropItem/Box/Mesh.FBX"),
		_T("./Res/Model/DropItem/Patch/Mesh.FBX"),
	};
	/// fpX̗vf
	const int nKPModelFilePathCount = SIZE_OF_ARRAY(nKPModelFilePaths);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DropItemChipset::DropItemChipset()
{
	// UNDONE:`bv̔z쐬B
	mChips.clear();
	mChips.reserve(nKPModelFilePathCount);	//< z̗eʂ\ߌ߂ďɗD
	for (int i = 0; i < nKPModelFilePathCount; ++i)
	{
		// fǂݍ
		const TCHAR* const kPFilePath = nKPModelFilePaths[i];

		SP<StaticModelDX9> pModel(NEW StaticModelDX9());
		pModel->LoadMesh(kPFilePath);

		// zɒǉ
		SP<SChip> pSChip(NEW SChip());
		pSChip->mPModel = pModel;

		mChips.push_back(pSChip);
	}
}

/// fXgN^
DropItemChipset::~DropItemChipset()
{
}

/// `bv擾
SP<DropItemChipset::SChip> DropItemChipset::GetChip(ItemCategoryTag::EItemCategoryTag eTag)
{
	return GetChipAt(eTag);
}

/// `bv擾
SP<DropItemChipset::SChip> DropItemChipset::GetChipAt(int index)
{
	const bool kIsInRange = MathHelper::IsInOfRange<int>(index, mChips.size());
	ASSERT_PF(kIsInRange, _T("CfbNX͈͊OłB"));
	if (kIsInRange)
	{
		return mChips.at(index);
	}

	return SP<DropItemChipset::SChip>();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// `bṽXg擾BconsttB
const DropItemChipset::ChipList* DropItemChipset::GetChips() const
{
	return &mChips;
}

/// `bṽXg擾
DropItemChipset::ChipList* DropItemChipset::GetChips()
{
	return const_cast<ChipList*>( static_cast<const DropItemChipset*>(this)->GetChips() );
}