#include "DX9GameEntry.h"


#include "Blast/Graphic/TextRendererColorTag.h"
#include "Blast/Graphic/DirectX9/DebugPrintDX9.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

// ͊֘A
#include "Blast/Input/DirectX8/InputDX8.h"
#include "Blast/Input/DirectX8/KeyboardDX8.h"
#include "Blast/Input/DirectX8/MouseDX8.h"
#include "Blast/Input/DirectX8/JoystickDX8.h"

// VOgŎg
#include "Blast/Base/DebugManager.h"
#include "Blast/Base/ResourceManager.h"
#include "Blast/Base/SequenceManager.h"

#include "Blast/Base/MenuEntryListScroll.h"

#include "Blast/Base/IMenuEntry.h"
#include "Blast/Base/MenuEntryNumeric.h"

// V[PX֘ABŏɑV[PX̃CX^XɕKvB
#include "Sequence/DebugSequence.h"

// CSV֘A
#include "ModelCSV.h"
#include "EnemyCSV.h"
#include "ItemCSV.h"
#include "TrapCSV.h"

// f[^x[X֘A
#include "DungeonDatabase.h"
#include "FloorDatabase.h"
#include "CharacterDatabase.h"
#include "ItemDatabase.h"
#include "TrapDatabase.h"

#include "Possession.h"

// ̑Auꏊɍ̂ȂǁB
#include "MapDataManager.h"
#include "Blast/Graphic/SpriteBatch.h"
#include "Camera2D.h"
#include "Blast/Graphic/DirectX9/FontDX9.h"

using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::Memory;
using namespace Blast::Graphic;
using namespace Blast::Input;
using namespace Blast::String;
using namespace Sequence;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DX9GameEntry::DX9GameEntry(HINSTANCE hInstance, HWND hWnd)
	: DX9GameBase(hInstance, hWnd)
	, mFPSCounter()
	, mFPSFixation()
	, mFPSCounterOX(1000)
{
}

/// fXgN^
DX9GameEntry::~DX9GameEntry()
{
}

/// 
HRESULT DX9GameEntry::Initialize()
{
	PFL(_T("DX9GameEntryInitializes܂B"));

	// DirectInput8쐬
	InputDX8* pInputDX8 = InputDX8::CreateInstance();
	bool isOk = pInputDX8->CreateInput(mHInstance);

	// L[{[h쐬
	KeyboardDX8* pKeyboard = NEW KeyboardDX8();
	pKeyboard->Create(mHWnd, InputDX8::GetInstance()->GetInput());

	// }EX쐬
	MouseDX8* pMouse = NEW MouseDX8();
	pMouse->Create(mHWnd, InputDX8::GetInstance()->GetInput());

	// WCXeBbN쐬
	JoystickDX8* pJoystick = NEW JoystickDX8();
	pJoystick->Create(mHWnd, InputDX8::GetInstance()->GetInput());

	// Cvbg}l[W[̍쐬
	InputManager* pInputManager = InputManager::CreateInstance();
	pInputManager->SetMouse(pMouse);
	pInputManager->SetKeyboard(pKeyboard);
	pInputManager->SetJoystick(pJoystick);


	// wp[̃P[V{ɐݒ
	StringHelper::SetLocaleJapan();


	// fobO}l[W[쐬
	DebugManager* pDM = DebugManager::CreateInstance();

	// \[X}l[W[쐬
	ResourceManager::CreateInstance();

	// V[PX}l[W[쐬
	SequenceManager* pSM = SequenceManager::CreateInstance();


	// CSVt@CǍ
	ModelCSV::CreateInstance();
	EnemyCSV::CreateInstance();
	ItemCSV::CreateInstance();
	TrapCSV::CreateInstance();

	// ef[^x[X쐬
	DungeonDatabase* pDDB = DungeonDatabase::CreateInstance();
	FloorDatabase* pFDB = FloorDatabase::CreateInstance();
	CharacterDatabase* pCDB = CharacterDatabase::CreateInstance();
	ItemDatabase* pIDB = ItemDatabase::CreateInstance();
	//TrapDatabase* pTDB = TrapDatabase::CreateInstance();	//< svɂȂ

	Possession::CreateInstance();

	// }bvf[^̃}l[W[쐬BɒuĂ悢̂mB
	MapDataManager::CreateInstance();

	// XvCgob`쐬
	SpriteBatch* pSB = SpriteBatch::CreateInstance();
	pSB->SetCamera( SP<Camera2D>(NEW Camera2D()) );

	// FPSݒ
	mFPSFixation.Initialize();
	mFPSFixation.SetFPS(60);

	// ŏ̃V[PXǉ
#if _DEBUG
	// fobOpV[PXǉ
	SP<DebugSequence> pDS(NEW DebugSequence());
	pSM->AddSequence(pDS);
#else
	// TODO:^CgV[PXǉ
	// DUMMY:V[PX쐬
	// DUMMY:V[PXǉ
#endif // _DEBUG

	return S_OK;
}

/// Xebv
HRESULT DX9GameEntry::Step()
{
	// CAUTION:[v
	while (true)
	{
#ifdef _DEBUG
		// FPS`
		double fps = mFPSCounter.GetFPS();
		DP(925, 0, 0xffffff00, _T("FPS:%8.4lf"), fps);
		DP(925, 12, 0xffffff00, _T("SPF:%8.4lf"), static_cast<float>(1 / fps));
		mFPSFixation.DebugRender(10, 650);

		// Ctrl+DŃfobO@\̗LA̐؂ւ
		DP(0, SCREEN_SIZE_HEIGHT - 16, 0xff000000, _T("Ctrl+DŃfobO@\̗LA̐؂ւ"));

		// OXFPS̒l`
		{
			double oxFPS = mFPSCounterOX.GetFPS();
			TCHAR oxFPSText[32] = { '\0' };
			StringHelper::Format(oxFPSText, SIZE_OF_ARRAY(oxFPSText), _T("oxFPS:%16.12lf"), oxFPS);

			Point oxFPSPos(SCREEN_SIZE_WIDTH - 120, SCREEN_SIZE_HEIGHT - DebugManager::GetInstance()->GetDebugPrint()->GetPointSize());
			DP(oxFPSPos.mX, oxFPSPos.mY, ColorCode::ToCode(ColorCode::eCOLOR_PINK), oxFPSText);
		}
#endif // _DEBUG

		// ŒFPSXV
		mFPSFixation.Update();

		// \ȃt[ł͂ȂȂ
		if (!mFPSFixation.IsAllowedFrame())
		{
			Sleep(1);

			continue;
		}

		break;
	}

	// XVԂ擾
	const float kDelta = static_cast<float>(mFPSFixation.GetDeltaTime());

	// \[X}l[W[XV
	ResourceManager* pRM = ResourceManager::GetInstance();
	pRM->Update(kDelta);

	// Cvbg}l[W[̍XV
	InputManager* pIM = InputManager::GetInstance();
	pIM->Update(kDelta);


	// V[PX}l[W[̏
	SequenceManager* pSM = SequenceManager::GetInstance();
	pSM->HandleInput(kDelta);
	pSM->Update(kDelta);
	pSM->Render();

#if _DEBUG
	// fobO}l[W[̏B
	// 肪ȂAV[PX}l[W[̏ƕB
	DebugManager* pDM = DebugManager::GetInstance();
	pDM->HandleInput(kDelta);
	pDM->Update(kDelta);
	pDM->Render();
#endif // _DEBUG

	return S_OK;
}

/// I
HRESULT DX9GameEntry::Release()
{
	PF(_T("DX9GameEntryReleases\n"));

	// MEMO:ԂƂ͋t̏ɉĂ܂B

	// XvCgob`j
	SpriteBatch::DestroyInstance();

	// ef[^x[Xj
	Possession::DestroyInstance();

	//TrapDatabase::DestroyInstance();	//< svɂȂ
	ItemDatabase::DestroyInstance();
	CharacterDatabase::DestroyInstance();
	DungeonDatabase::DestroyInstance();
	FloorDatabase::DestroyInstance();

	// CSVj
	TrapCSV::DestroyInstance();
	ItemCSV::DestroyInstance();
	EnemyCSV::DestroyInstance();
	ModelCSV::DestroyInstance();

	// V[PX}l[W[j
	SequenceManager::DestroyInstance();

	// \[X}l[W[j
	ResourceManager::DestroyInstance();

	// fobO}l[W[j
	DebugManager::DestroyInstance();


	// Cvbg}l[W[j
	InputManager::DestroyInstance();

	// DirectInput8j
	InputDX8::DestroyInstance();

	return S_OK;
}