#include "Chipset.h"

#include "MapDataManager.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Chipset::Chipset()
	: mETag(ChipsetTag::eCHIPSET_GLASSLAND)
{
	// `bvzm
	for (int i = 0; i < MapDataManager::MAX_CHIPSET_CHIP_COUNT; ++i)
	{
		mPChips[i].SetPointer(NEW Chip());
	}
}

/// fXgN^
Chipset::~Chipset()
{
}

/// 
void Chipset::Initialize(int id)
{
	const MapDataManager::SChipsetData& kRSData = MapDataManager::GetInstance()->GetChipsetData(static_cast<ChipsetTag::EChipsetTag>(id));

	// `bvz쐬
	mETag = kRSData.mEChipsetTag;
	for (int i = 0; i < MapDataManager::MAX_CHIPSET_CHIP_COUNT; ++i)
	{
		mPChips[i]->Initialize(kRSData.mEChipTags[i]);
	}
}
