#include "Chip.h"

#include "Blast/Base/ResourceManager.h"
#include "MapDataManager.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Chip::Chip()
	: mETag(ChipTag::eCHIP_WALL_0)
{
}

/// fXgN^
Chip::~Chip()
{
}

/// 
void Chip::Initialize(int id)
{
	const MapDataManager::SChipData& kRSData = MapDataManager::GetInstance()->GetChipData(static_cast<ChipTag::EChipTag>(id));
	mETag = kRSData.mEChipTag;
	mEKindTag = kRSData.mEChipKindTag;

	// HACK:fǂݍށB̃NX쐬̂ŁAԂ̃{glbNɂȂB
	mPModel.SetPointer(NEW StaticModelDX9());
	mPModel->LoadMesh(kRSData.mPModelFilePath);

	// MEMO:̃NX`悷킯ȂAŃVF[_[𓖂ĂĂ
	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<ShaderEffectDX9> pShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT));
	mPModel->SetShaderEffect(pShader);

	// ̃eNjbNݒ
	#if _DEBUG
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME));
	#else
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT));
	#endif	// _DEBUG
}