#ifndef CHARACTER_H
#define CHARACTER_H

#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/DirectX9/CrosshairDX9.h"
#include "Blast/Graphic/ICamera.h"
#include "Direction.h"
#include "SkinModel.h"


/// vg^Cv
class Terrain;

/// LN^[̏SNX
class Character :
	public Blast::Base::RenderableGameComponent
{
public:
	//====================================================================================================
	// Enumerate
	//----------------------------------------------------------------------------------------------------

	/// LN^[̃^Cv̗񋓑
	enum ECharacter
	{
		/// vC[
		eCHARACTER_PLAYER,

		/// 
		eCHARACTER_FRIEND,

		/// G
		eCHARACTER_ENEMY,

		/// NPC
		eCHARACTER_NPC,


		/// 񋓗vf̐
		eCHARACTER_COUNT,

		/// Ȓl
		eCHARACTER_INVALID,

		/// ̒l
		eCHARACTER_INITIAL,
	};


	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// p[^[
	struct SParameter
	{
	public:
		/// RXgN^
		SParameter() :
		  mLevel(-1),
		  mHP(-1),
		  mMaxHP(-1),
		  mSatiety(-1),
		  mMaxSatiety(-1),
		  mPower(-1),
		  mMaxPower(-1),
		  mOffence(-1),
		  mDefence(-1),
		  mExperience(-1)
		{
		}

		int mLevel;			///< x
		int mHP;			///< HP
		int mMaxHP;			///< őHP
		int mSatiety;		///< x
		int mMaxSatiety;	///< ő喞x
		int mPower;			///< 
		int mMaxPower;		///< ͂̍ől
		int mOffence;		///< U
		int mDefence;		///< h
		int mExperience;	///< ol
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	Character();

	/// fXgN^
	virtual ~Character();


	/// ǂݍ
	bool Load(const TCHAR* const);

	/// XV
	void Update(float);

	/// `
	void Render();


	/// 擾
	const Direction& GetDirection() const { return mDirection; }
	/// ύX
	void ChangeDirection(Direction::EDirection);

	/// LN^[̃^Cv擾
	ECharacter GetCharacterType() const { return mECharacterType; }
	/// LN^[̃^Cvݒ
	void SetCharacterType(ECharacter eValue) { mECharacterType = eValue; }

	/// O擾
	const TCHAR* const GetName() const { return mNameStr.c_str(); }
	/// Oݒ
	void SetName(const TCHAR* const kPValue) { mNameStr = kPValue; }

	/// \擾
	const TCHAR* const GetDisplayName() const { return mDisplayNameStr.c_str(); }
	/// Oݒ
	void SetDisplayName(const TCHAR* const kPValue) { mDisplayNameStr = kPValue; }

	/// tÄʒu擾
	const Blast::Math::Point& GetTilePoint() const { return mTilePosition; }
	/// tÄʒuݒ
	void SetTilePoint(const Blast::Math::Point& kRValue) { mTilePosition = kRValue; }

	/// p[^[擾
	const SParameter& GetParameter() const { return mSParameter; }
	/// p[^[擾
	SParameter& GetParameter() { return mSParameter; }
	/// p[^[ݒ
	void SetParameter(const SParameter& kRSParameter) { mSParameter = kRSParameter; }


	/// UNDONE:HPɃ_[W󂯂
	int DamageHP(int);

	/// UNDONE:񂾂ǂ擾
	bool IsDead() const;


	/// Jݒ
	void SetCamera(const SP<Blast::Graphic::ICamera> pCamera) { mPCamera = pCamera; }

	/// f擾
	SP<SkinModel> GetModel() { return mPModel; }
	
private:
	/// O
	tstring mNameStr;

	/// \
	tstring mDisplayNameStr;

	/// tÄʒu
	Blast::Math::Point mTilePosition;

	/// LN^[̃^Cv
	ECharacter mECharacterType;

	/// 
	Direction mDirection;

	/// p[^[
	SParameter mSParameter;

	
	/// J
	SP<Blast::Graphic::ICamera> mPCamera;

	/// f
	SP<SkinModel> mPModel;

	/// NXwABȈՕ\pŎۂ͕\ȂB
	SP<Blast::Graphic::CrosshairDX9> mPCrosshair;
};

#endif // CHARACTER_H