#ifndef CAMERA3D_H
#define CAMERA3D_H

#include "Blast/Base/GameComponent.h"
#include "Blast/Graphic/CameraBase.h"


/// 3Dp̃JSNX
class Camera3D :
	public Blast::Base::GameComponent,
	public Blast::Graphic::CameraBase
{
public:
	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	Camera3D();

	/// fXgN^
	virtual ~Camera3D();
	
	
	/// 
	virtual void Initialize();
	
	/// XV
	virtual void Update(float);


	/// Y]s擾
	const Blast::Math::Matrix& GetRotateMatrixY() const { return mRotateMatrixY; }

	/// ]s擾
	const Blast::Math::Matrix& GetRotateMatrixZXY() const { return mRotateMatrixZXY; }


	/// ʒu擾
	const Blast::Math::Vector3& GetPosition() const { return mPosition; }

	/// _擾
	const Blast::Math::Vector3& GetLookAt() const { return mLookAt; }

	/// [h̏ւ̒PʃxNg擾
	const Blast::Math::Vector3& GetWorldUpUnit() const { return mWorldUpUnit; }

	/// ]l擾
	const Blast::Math::Vector3& GetRotation() const { return mRotation; }

	/// ˉe@擾
	Blast::Graphic::Projection::EProjection GetEProjection() const { return mEProjection; }


	/// p擾
	float GetFieldOfViewY() const { return mFieldOfViewY; }


	/// jANbv擾
	float GetNearClip() const { return mNearClip; }

	/// t@[Nbv擾
	float GetFarClip() const { return mFarClip; }


	/// O̒PʃxNg擾
	virtual Blast::Math::Vector3 GetFrontUnit() const;

	/// E̒PʃxNg擾
	virtual Blast::Math::Vector3 GetRightUnit() const;

	/// ̒PʃxNg擾
	virtual Blast::Math::Vector3 GetUpUnit() const;


	/// ʒuݒ
	void SetPosition(float x, float y, float z, bool isLookAtWith = false);

	/// ʒuݒ
	void SetPosition(const Blast::Math::Vector3&, bool isLookAtWith = false);


	/// _ݒ
	void SetLookAt(float x, float y, float z);

	/// _ݒ
	void SetLookAt(const Blast::Math::Vector3&);


	/// [h̏̒PʃxNgݒ
	void SetWorldUpUnit(float x, float y, float z);

	/// [h̏̒PʃxNgݒ
	void SetWorldUpUnit(const Blast::Math::Vector3&);


	/// ]ݒ
	void SetRotationZXY(float x, float y, float z);

	/// ]ݒ
	void SetRotationZXY(const Blast::Math::Vector3&);


	/// ˉe@ݒ
	void SetEProjection(Blast::Graphic::Projection::EProjection e) { mEProjection = e; }


	/// pݒ
	void SetFieldOfViewY(float fovy) { mFieldOfViewY = fovy; }

	/// ݒ
	void SetWidth(float width) { mWidth = width; }

	/// cݒ
	void SetHeight(float height) { mHeight = height; }


	/// ʒuړ
	void Move(float x, float y, float z, bool isLookAtWith = true);

	/// ʒuړ
	void Move(const Blast::Math::Vector3&, bool isLookAtWith = true);


	/// ʒuɉĈړ
	void MoveAxis(float x, float y, float z, bool isLookAtWith = true);

	/// ʒuɉĈړ
	void MoveAxis(const Blast::Math::Vector3&, bool isLookAtWith = true);


	/// _ړ
	void MoveLookAt(float x, float y, float z);

	/// _ړ
	void MoveLookAt(const Blast::Math::Vector3&);
	

	/// _ɉĈړ
	void MoveLookAtAxis(float x, float y, float z);

	/// _ɉĈړ
	void MoveLookAtAxis(const Blast::Math::Vector3&);


	/// ]
	void RotateZXY(float x, float y, float z);

	/// ]
	void RotateZXY(const Blast::Math::Vector3&);


	/// _𒆐SɌ]
	void RevolveZXY(float x, float y, float z);

	/// _𒆐SɌ]
	void RevolveZXY(const Blast::Math::Vector3&);


	/// Y[
	void Zoom(float);

	
	/// ]lXV
	void UpdateRotation();


#ifdef _DEBUG
	//====================================================================================================
	// Debug
	//----------------------------------------------------------------------------------------------------

	/// \
	void DebugRender(int x, int y);
#endif // _DEBUG

private:
	/// ʒu
	Blast::Math::Vector3 mPosition;

	/// _
	Blast::Math::Vector3 mLookAt;

	/// [h̏ւ̒PʃxNg
	Blast::Math::Vector3 mWorldUpUnit;


	/// ]
	Blast::Math::Vector3 mRotation;

	/// Y]s
	Blast::Math::Matrix mRotateMatrixY;

	/// ]s
	Blast::Math::Matrix mRotateMatrixZXY;


	/// ˉe̎
	Blast::Graphic::Projection::EProjection mEProjection;


	/// p
	float mFieldOfViewY;

	/// 
	float mWidth;

	/// c
	float mHeight;

	/// AXyNg
	float mAspectRatio;


	/// jANbv
	float mNearClip;

	/// t@[Nbv
	float mFarClip;

	
	//====================================================================================================
	// PrivateOperation
	//----------------------------------------------------------------------------------------------------

	/// r[sXV
	void UpdateView();

	/// ˉesXV
	void UpdateProjection();

	/// r[|[gsXV
	void UpdateViewport();
};

#endif // CAMERA3D_H