#include "Camera2D.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

	/* vpeB */

	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	Camera2D::SCamera2DProperty::SCamera2DProperty()
	{
		// 
		Initialize();
	}

	/// 
	void Camera2D::SCamera2DProperty::Initialize()
	{
		mPosition = Vector3::UnitZ() * -1000.0f;
		mLookAt = Vector3::Zero();
		mWorldUpUnit = Vector3::UnitY();

		// MEMO:Ac̓XN[TCY擾đׂł傤B
		mWidth = 1024;
		mHeight = 768;

		mNearClip = -1000.0f;
		mFarClip = 1000.0f;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Camera2D::Camera2D()
{
	Initialize();
}

/// fXgN^
Camera2D::~Camera2D()
{
}

/// 
void Camera2D::Initialize()
{
	// vpeB
	mSCamera2DProperty.Initialize();


	// r[sXV
	UpdateView();

	// ˉesXV
	UpdateProjection();

	// r[|[gsXV
	UpdateViewport();
}

/// XV
void Camera2D::Update(float delta)
{
	// r[sXV
	UpdateView();

	// ˉesXV
	UpdateProjection();

	// r[|[gsXV
	UpdateViewport();
}


#ifdef _DEBUG
//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// \
void Camera2D::DebugRender(int x, int y)
{
	// s
	const int kMatrixSpacing = 70;

	// os
	const int kSubheadSpacing = 12;

	// sCfbNX
	int dataIndex = 0;


	// ʒu
	int posX = x;
	int posY = y;


	// r[s\
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("r[s"));
	mViewMatrix.DebugRender(posX, posY + kSubheadSpacing);

	// ˉes\
	++dataIndex;
	posY = y + kMatrixSpacing * dataIndex;

	DP(posX, posY, 0xffff8888, _T("ˉes"));
	mProjectionMatrix.DebugRender(posX, posY + kSubheadSpacing);
}
#endif // _DEBUG


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// r[sXV
void Camera2D::UpdateView()
{
	// r[s쐬
	mViewMatrix.Identity();
	mViewMatrix.CreateViewLH(
		mSCamera2DProperty.mPosition,
		mSCamera2DProperty.mLookAt,
		mSCamera2DProperty.mWorldUpUnit);
}

/// ˉesXV
void Camera2D::UpdateProjection()
{
	// EBhE̍オ_̐ˉes쐬
	mProjectionMatrix.Identity();
	mProjectionMatrix.CreateOrthoGraphicLH(
		mSCamera2DProperty.mWidth,
		mSCamera2DProperty.mHeight,
		mSCamera2DProperty.mNearClip,
		mSCamera2DProperty.mFarClip
		);

	/*	MEMO[131201]:
	*	Y𔽓]A_ɂ炷ƂŁA
	*	EWn
	*	XN[Wnɂ܂B
	*/
	mProjectionMatrix.m22 *= -1;
	mProjectionMatrix.m41 = -1;
	mProjectionMatrix.m42 = 1;
}

/// r[|[gsXV
void Camera2D::UpdateViewport()
{
	mViewportMatrix.Identity();
}