//====================================================================================================
// GlobalField
//----------------------------------------------------------------------------------------------------

// [hs
float4x4 gWorld =
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

// [hWnˉeWnւ̕ϊs
float4x4 gWVP =
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

// [hs̋t̓]us
//float4x4 gWIT =
//{
//	1, 0, 0, 0,
//	0, 1, 0, 0,
//	0, 0, 1, 0,
//	0, 0, 0, 1,
//};


// ̕
float3 gLightDirection = { 1, 1, 1 };

// MEMO:F+łB
// ̋
float4 gLightIntensity = { 1, 1, 1, 1 };

// fBt[YJ[
float4 gDiffuse = { 1, 1, 1, 1 };


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

// sNZVF[_֓nf[^
struct VS_OUTPUT
{
    float4 mPosition		: POSITION;
    float4 mColor			: COLOR;
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

// o[ebNXVF[_
VS_OUTPUT VS(
	float4 position	: POSITION,	// _W
	float3 normal	: NORMAL	// @
)
{
	// o̓f[^p
	VS_OUTPUT sOut = (VS_OUTPUT)0;

	// ʒuW[hϊ
	sOut.mPosition = mul(position, gWVP);


	// MEMO:@ϊAϊǂł傤B
	// @[hϊ
	float3 WNormal = normalize(mul(normal, gWorld));

	// o[ggUˌvZ
	float4 lightIntensity = float4(gLightIntensity.xyz * gLightIntensity.w, 1);
	sOut.mColor = gDiffuse * lightIntensity * dot(WNormal, gLightDirection);


	// o
	return sOut;
}

// sNZVF[_
float4 PS (VS_OUTPUT sIn) : COLOR
{
    return sIn.mColor;
}


//====================================================================================================
// Technique
// ---------------------------------------------------------------------------------------------------

// MEMO:ǂʂׂfłĂ܂B
// HHH
technique Solid
{
	// pX
    pass P0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = CCW;
        ZEnable = True;
        ZWriteEnable = True;
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
    
	// pX
    pass P1
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = NONE;
        ZEnable = False;
        ZWriteEnable = False;
        
        FillMode = WireFrame;
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
}

// C[t[݂̂̕`
technique WireFrame
{
	// pX
    pass P0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        Lighting = False;
        CullMode = NONE;
        ZEnable = False;
        ZWriteEnable = False;
        
        // tB[hC[t[ɐݒ
        FillMode = WireFrame;
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
}
