#ifndef LAMBERT_FX
#define LAMBERT_FX

#include "EffectFunction.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// o[gsNZVF[_֓nf[^
struct LAMBERT_VS_OUTPUT
{
    float4 mPosition		: POSITION;
    float2 mUV				: TEXCOORD0;
    float4 mColor			: TEXCOORD1;
};


//====================================================================================================
// Shader
//----------------------------------------------------------------------------------------------------

/// o[go[ebNXVF[_
LAMBERT_VS_OUTPUT LambertVS(
	float4 position	: POSITION,	// _W
	float2 uv		: TEXCOORD,	// eNX`W
	float3 normal	: NORMAL	// @
)
{
	// o̓f[^p
	LAMBERT_VS_OUTPUT sOut = (LAMBERT_VS_OUTPUT)0;


	// ʒuWݒ
	sOut.mPosition = mul(position, gWVP);


	// MEMO:Ȃvf0ŏ̂ŖI1ŏ܂B
	// UVWݒ
	float4 uv4 = float4(uv.x, uv.y, 1.0f, 1.0f);
	sOut.mUV = mul(uv4, gUVMatrix).xy;
	
	
	// o[ggUˌZo
	sOut.mColor.rgb += CalcLambert(normal);
	
	// Z
	sOut.mColor.rgb += CalcAmbient();
	
	
	// MEMO:ʂ̕ϐpӂǂł傤B
	// At@sł1ɐݒ
	sOut.mColor.a = 1;


	// o
	return sOut;
}

/// o[gsNZVF[_
float4 LambertPS(LAMBERT_VS_OUTPUT sIn) : COLOR
{
	// sNZJ[p
	float4 pixelColor = sIn.mColor;

	// fBt[YeNX`TvO
	pixelColor *= DiffuseTextureSampling(sIn.mUV);


    return pixelColor;
}


#endif // LAMBERT_FX
