//====================================================================================================
// GlobalField
//----------------------------------------------------------------------------------------------------

/// Ԏ
float gDurationTime = 0;

/// ԎԂ̔B
/// [eNX`̃TvO
float gHalfDurationTime = 0;

/// oߎ
float gElapsedTime = 0;

/// tF[hCǂBtrueȂ1B
int gFadeDirectionIn = 0;

/// jo[TȂ
bool gIsUniversal = true;


/// ArGg
float4 gAmbientColor = { 1, 1, 1, 1 };


/// fBt[YeNX`
texture gDiffuseTexture;

/// [eNX`
texture gRuleTexture;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

// sNZVF[_֓nf[^
struct VS_OUTPUT
{
	float4 mPosition		: POSITION;
    float4 mColor			: COLOR0;
    float2 mUV				: TEXCOORD0;
};


//====================================================================================================
// SamplerState
//----------------------------------------------------------------------------------------------------

/// fBt[YeNX`p
sampler DiffuseSampler
{
	Texture = <gDiffuseTexture>;

	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;

	AddressU = Wrap;
	AddressV = Wrap;
};

/// [eNX`p
sampler RuleSampler = sampler_state
{
    Texture = <gRuleTexture>;
    
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;

	// MEMO:UVXN[̂߁AWrapɂ܂B
    AddressU = Wrap;
    AddressV = Wrap;
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

// o[ebNXVF[_
VS_OUTPUT VS(
	float4 position	: POSITION,	// ʒu
	float2 uv		: TEXCOORD	// eNX`W
){
	// o̓f[^p
	VS_OUTPUT sOut = (VS_OUTPUT)0;

	// TCY̓AvʑŜ𕢂TCY͂Ȃ̂ŁAł͋Cɂ܂B
	sOut.mPosition = position;

	// F̓ArGgn
	sOut.mColor = gAmbientColor;

	// MEMO:Ȃvf0ŏ̂ŖI1ŏ܂B
	// UVWϊ
	float4 uv4 = float4(uv.x, uv.y, 1.0f, 1.0f);
	sOut.mUV = uv4;


	// o
	return sOut;
}

// sNZVF[_
float4 PS (VS_OUTPUT sIn) : COLOR
{
	// sNZJ[
	float4 pixelColor = sIn.mColor;

	// MEMO:fBt[ỸeNX`ݒ肵ȂƕK^ɂȂĂ܂܂B
	// fBt[YTvO
	pixelColor *= tex2D(DiffuseSampler, sIn.mUV);
	

	// MEMO:sNZVF[_[ifCɂȂł傤B
	// jo[TȂ
	if (gIsUniversal)
	{
		// [TvO
		float4 ruleColor = tex2D(RuleSampler, sIn.mUV);
		float ruleAverage = (ruleColor.r + ruleColor.g + ruleColor.b) / 3.0f;
		pixelColor.a = (gElapsedTime - (gHalfDurationTime * ruleAverage)) / gHalfDurationTime;
	}
	// jo[TłȂȂ
	else
	{
		pixelColor.a = gElapsedTime / gDurationTime;
	}


	// MEMO:Ô߂łB
	// Nv
	pixelColor.a = clamp(pixelColor.a, 0, 1);

	// MEMO:tF[hCȂAt@lts܂B
	pixelColor.a = abs(pixelColor.a - gFadeDirectionIn);
	
    return pixelColor;
}


//====================================================================================================
// Technique
// ---------------------------------------------------------------------------------------------------

// ʏ
technique Solid
{
	// At@t`
    pass P0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = NONE;
        
        // ZeXgAZobt@ւ݂̏s܂B
        ZEnable = False;
        ZWriteEnable = False;
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
}

/// C[t[
technique WireFrame
{
    pass P0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        Lighting = False;
        CullMode = NONE;
        ZEnable = True;
        ZWriteEnable = True;
        
        // C[t[w
        FillMode = WireFrame;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
}

/// \bhƃC[t[
technique SolidWireFrame
{
	// At@t`
    pass P0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        CullMode = NONE;
        
        // ZeXgAZobt@ւ݂̏s܂B
        ZEnable = False;
        ZWriteEnable = False;
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
    
    pass P1
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        Lighting = False;
        CullMode = NONE;
        
        // ZeXgAZobt@ւ݂̏s܂B
        ZEnable = False;
        ZWriteEnable = False;
        
        // C[t[w
        FillMode = WireFrame;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 VS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 PS();
    }
}