#ifndef EFFECT_FUNCTION_FX
#define EFFECT_FUNCTION_FX


//====================================================================================================
// Define
//----------------------------------------------------------------------------------------------------

//`
#define MAX_BONE_MATRICES 255


//====================================================================================================
// GlobalField
//----------------------------------------------------------------------------------------------------

/// [hs
float4x4 gWorld = 
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

/// r[s
float4x4 gView = 
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

/// vWFNVs
float4x4 gProjection = 
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

/// r[|[gs
float4x4 gViewport = 
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};


/// [JWnXN[Wnւ̕ϊs
float4x4 gWVP =
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};

/// UVϊs
float4x4 gUVMatrix =
{
	1, 0, 0, 0,
	0, 1, 0, 0,
	0, 0, 1, 0,
	0, 0, 0, 1,
};


/// fBt[Y
float4 gDiffuse = { 1, 1, 1, 1 };

/// fBt[YeNX`
texture gDiffuseTexture;

/// fBt[YeNX`gp邩
bool gIsUseDiffuseTexture = true;


/// ւ̕
float3 gLightDirection =
{
	1, 1, -1
};


/// XyL
float4 gSpecular = { 1, 1, 1, 1 };

/// 
float gShininess = 4;


/// 
float4 gAmbientColor =
{
	1, 1, 1, 0.25f
};


/// J̃[hʒu
float3 gEyePosition = { 1, 1, -1 };


/// {[̃Jg|[Ys
matrix gCurrentPose[MAX_BONE_MATRICES];


//====================================================================================================
// SamplerState
//----------------------------------------------------------------------------------------------------

/// fBt[YTvXe[g
sampler DiffuseSampler = sampler_state
{
    Texture = <gDiffuseTexture>;
    
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;

    AddressU = Clamp;
    AddressV = Clamp;
};


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// XLjȌ
struct SSkinning
{
	/// _ʒu
	float4 mPosition;

	/// @
	float3 mNormal;
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// fBt[YeNX`TvO
float4 DiffuseTextureSampling(float2 uv)
{
	// fBt[YeNX`gpȂ
	if (gIsUseDiffuseTexture)
	{
		// TvO
		return tex2D(DiffuseSampler, uv);
	}
	// fBt[YeNX`gpȂȂ
	else
	{
		// MEMO:FƌvZZɂĐ^ɂȂĂ܂܂B
		return float4(1, 1, 1, 1);
	}
};

/// o[ggUˌZo
float3 CalcLambert(float3 normal)
{
	// @[hϊĒPʉ
	float3 N = normalize( mul(normal, gWorld).xyz );
	
	// ւ̕xNgPʉ
	float3 lightDirN = normalize(gLightDirection);
	
	
	// gUˌWZo
	float L = saturate( dot(N.xyz, lightDirN) );
	
	
	return gDiffuse.rgb * L * gDiffuse.w;
};

/// Zo
float3 CalcAmbient()
{
	return gAmbientColor.rgb * gAmbientColor.w;
};

/// tHʔˌZo
float3 CalcSpecular(float3 normal, float4 localPosition)
{
	// @[hϊĒPʉ
	float3 N = normalize( mul(normal, gWorld).xyz );

	// ւ̕xNgPʉ
	float3 lightDirN = normalize(gLightDirection);


	// ʒu[hϊ
	float3 worldPos = mul(localPosition, gWorld).xyz;

	// Jւ̕xNgPʉ
	float3 toEyeDirN = normalize(gEyePosition - worldPos);
		
	// ˌWZo
	float3 NL = saturate( dot(N, lightDirN) );
	float3 R = normalize(2 * NL * N - lightDirN);


	// ʔˌWZo
	float3 S = 2 * pow( saturate( dot(R, toEyeDirN) ), gShininess);


	return gSpecular.rgb * S * gSpecular.w;
};

/// XLjOʂZo
SSkinning Skinning(float4 position, float3 normal, uint4 boneIndices, float4 boneWeights)
{
	// o͏
	SSkinning sOut = (SSkinning)0;


	// _1ɑ΂ĉe^{[̍ő吔Ń[v
	const int kMaxInfluenceBoneCount = 4;
	for (int i = 0; i < kMaxInfluenceBoneCount; ++i)
	{
		// CfbNX擾
		uint boneIndex = boneIndices[i];

		// EFCg擾
		float boneWeight = boneWeights[i];

		// s擾
		matrix poseMatrix = gCurrentPose[boneIndex];


		// ϊ
		sOut.mPosition += boneWeight * mul(position, poseMatrix);
		sOut.mNormal += boneWeight * mul(normal, (float3x3)poseMatrix);
	}


	return sOut;
}


#endif // EFFECT_FUNCTION_FX
