#ifndef COMMONTEXTURESAMPLERS_FX
#define COMMONTEXTURESAMPLERS_FX


//====================================================================================================
// Texture
//----------------------------------------------------------------------------------------------------

/// fBt[YeNX`
texture gDiffuseTexture : DIFFUSE
<
	string UIName = "Diffuse Texture";
	string ResourceType = "2D";
>;

/// m[}(@)eNX`
texture gNormalTexture
<
	string UIName = "NormalMap Texture";
	string ResourceType = "2D";
>;

/// eNX`
texture gEnvironmentTexture : ENVIRONMENT
<
	string UIName = "EnvironmentMap Texture";
	string ResourceType = "Cube";
>;


//====================================================================================================
// SamplerState
//----------------------------------------------------------------------------------------------------

/// fBt[YTv[Xe[g
sampler2D DiffuseSampler = sampler_state
{
    Texture = <gDiffuseTexture>;
    
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;

    AddressU = Wrap;
    AddressV = Wrap;
};

/// m[}}bvTv[Xe[g
sampler2D NormalSampler = sampler_state
{
    Texture = <gNormalTexture>;
    
    FILTER = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
}; 

/// }bvTv[Xe[g
samplerCUBE EnvironmentSampler = sampler_state
{
    Texture = <gEnvironmentTexture>;
    
    FILTER = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
};

#endif // COMMONTEXTURESAMPLERS_FX
