#ifndef CHARACTER_FX
#define CHARACTER_FX

#include "stdafx.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// AvP[V炭钸_obt@ւ̏
struct SAppData
{
	float3	mPosition		: POSITION;		///< _W
	float2	mUV				: TEXCOORD0;	///< eNX`W
	float3	mNormal			: NORMAL;		///< @
	uint4	mBoneIndices	: BLENDINDICES;	///< {[CfbNX
	float4	mBoneWeights	: BLENDWEIGHT;	///< {[EFCg
	float	mInstanceIndex	: TEXCOORD1;	///< CX^XCfbNX
};

/// _obt@sNZVF[_֓nf[^
struct SVertexOutput
{
	float4	mPosition	: POSITION;		///< _ʒu
	float2	mUV			: TEXCOORD0;	///< UV
    int		mIsVisible	: TEXCOORD1;	///< `tO
};


//====================================================================================================
// VertexShader
//----------------------------------------------------------------------------------------------------

/// C
SVertexOutput MainVS(SAppData sIn)
{
	// o̓f[^p
	SVertexOutput sOut = (SVertexOutput)0;

	// ʒuWݒ
	float4 pos = float4(sIn.mPosition, 1);
	pos = Skinning(pos, sIn.mBoneIndices, sIn.mBoneWeights);	///< XLjO
	pos.xyz += gInstancePositions[sIn.mInstanceIndex].xyz;
	pos = mul(pos, gWorld);
	pos = mul(pos, gView);
	pos = mul(pos, gProjection);
	pos = mul(pos, gViewport);
	
	sOut.mPosition = pos;


	// UVWݒ
	float4 uv4 = float4(sIn.mUV.x, sIn.mUV.y, 1.0f, 1.0f);
	sOut.mUV = mul(uv4, gUVMatrix).xy;

	// `tO
	sOut.mIsVisible = 1;
	if (!gInstanceVisibles[sIn.mInstanceIndex])
	{
		sOut.mIsVisible = -1;
	}
	

	// o
	return sOut;
}


//====================================================================================================
// PixelShader
//----------------------------------------------------------------------------------------------------

/// C
float4 MainPS(SVertexOutput sIn) : COLOR
{
	// fBt[YJ[p
	float3 diffuseColor = tex2D(DiffuseSampler, sIn.mUV).rgb;

	// fBt[YeNX`TvO
	float3 result = diffuseColor * (0 + gAmbientColor);

	// `tOB0ł͂ȂA0łȂƔ\ɂȂȂB
	clip(sIn.mIsVisible);
	
    return float4(result, 1);
}

/// C[t[p
float4 WireframePS(SVertexOutput sIn) : COLOR
{
	// fBt[YJ[p
	float3 diffuseColor = tex2D(DiffuseSampler, sIn.mUV).rgb;

	// fBt[YeNX`TvO
	float3 result = diffuseColor * (0 + gAmbientColor);

	// یFɂȂȂ悤ɔ]
	result = float3(1, 1, 1) - result;

    return float4(result, 1);
}


//====================================================================================================
// Technique and Pass
//----------------------------------------------------------------------------------------------------

/// RX^g
technique Constant
{
	// \bh`pX
    pass Pass0
    {
        // _[Xe[gݒ
        AlphaBlendEnable = False;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;

#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif
        
        ZEnable = True;
        ZWriteEnable = True;
        
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
}

/// C[t[
technique WireFrame
{
	// C[t[`pX
    pass Pass0
    {        
        FillMode = Wireframe;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

#endif // CHARACTER_FX
