#include "Blast/Graphic/DirectX9/XYZAxisDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
XYZAxisDX9::XYZAxisDX9() :
mLength(500)
{
	/// C쐬
	mPLine.SetPointer(NEW Line3DDX9);
}

/// fXgN^
XYZAxisDX9::~XYZAxisDX9()
{
}


/// `
void XYZAxisDX9::Render()
{
	// Jݒ
	mPLine->SetCamera(mPCamera);


	// Xp̓_p
	Vector3 xAxis[] =
	{
		Vector3::Zero(),
		Vector3::UnitX() * mLength,
	};

	// Yp̓_p
	Vector3 yAxis[] = 
	{
		Vector3::Zero(),
		Vector3::UnitY() * mLength,
	};

	// Zp̓_p
	Vector3 zAxis[] = 
	{
		Vector3::Zero(),
		Vector3::UnitZ() * mLength,
	};

	// X`
	mPLine->GetLine3DDX9PropertyRef().mColor = Color::GetPreset(ColorCode::eCOLOR_RED);
	mPLine->Render(xAxis, 2);

	// Y`
	mPLine->GetLine3DDX9PropertyRef().mColor = Color::GetPreset(ColorCode::eCOLOR_LIMEGREEN);
	mPLine->Render(yAxis, 2);

	// Z`
	mPLine->GetLine3DDX9PropertyRef().mColor = Color::GetPreset(ColorCode::eCOLOR_MEDIUMBLUE);
	mPLine->Render(zAxis, 2);
}


/// Jݒ
void XYZAxisDX9::SetCamera(SP<ICamera> pCamera)
{
	mPCamera = pCamera;
}