#include "Blast/Application/WindowBase.h"

using namespace Blast::Application;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* EBhȄ */

/// 
void WindowBase::SProperty::Initialize(HINSTANCE hInstance, const TCHAR kClassName[])
{
	// MEMO:I[o[Ch鏈Ȃ̂ŁAł͍Œ삷ݒ̂ݍsĂ܂B

	// 
	ZeroMemory(this, sizeof(SProperty));

	// NX
	memcpy(mClassName, kClassName, SProperty::mStKClassNameBufferSize);

	// EBhE
	memcpy(mWindowName, _T("EBhE"), SProperty::mStKWindowNameBufferSize);

	// MEMO:ɗR΁wWS_OVERLAPPEDWINDOWxŖȂł
	// EBhEX^C
	mStyle = WS_OVERLAPPEDWINDOW;

	// XWʒu
	mPositionX = CW_USEDEFAULT;

	// YWʒu
	mPositionY = CW_USEDEFAULT;

	// 
	mWidth = 600;

	// c
	mHeight = 480;

	// eEBhẼnh
	mParentWindowHandle = NULL;

	// j[o[̃nh
	mMenuBarHandle = NULL;

	// CX^Xnh
	mHInstance = hInstance;

	// p[^[
	mParameter = NULL;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
WindowBase::WindowBase() :
mWindowHandle(NULL),
mSProperty()
{
}

/// fXgN^
WindowBase::~WindowBase()
{
}

/// 쐬
bool WindowBase::Create(const SProperty& rSProperty)
{
	// vpeBێ
	mSProperty = rSProperty;

	// EBhE쐬
	HWND hWnd = CreateWindow(
		rSProperty.mClassName,
		rSProperty.mWindowName,
		rSProperty.mStyle,
		rSProperty.mPositionX,
		rSProperty.mPositionY,
		rSProperty.mWidth,
		rSProperty.mHeight,
		rSProperty.mParentWindowHandle,
		rSProperty.mMenuBarHandle,
		rSProperty.mHInstance,
		rSProperty.mParameter
    );

	// EBhEnhȂ
	if (!hWnd)
	{
		OutputDebugString(_T("EBhE̍쐬Ɏs܂\n"));

		return false;
	}

	// EBhEnhێ
	mWindowHandle = hWnd;

	return true;
}

/// vV[W
LRESULT WindowBase::WindowProcedural(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   // ftHgł͏Î
   switch (message)
   {
		// EBhEjA܂
		// EBhEꂽ
		case WM_DESTROY:
		case WM_CLOSE:

			// I錾
			PostQuitMessage(0);
			
			break;

	   default:

		   return DefWindowProc(hWnd, message, wParam, lParam);
   }

   return 0;
}