#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"

#include "Blast/Graphic/VertexStreamType.h"

using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
VertexElementFactoryDX9::VertexElementFactoryDX9()
{
}

/// fXgN^
VertexElementFactoryDX9::~VertexElementFactoryDX9()
{
}


/// 쐬
D3DVERTEXELEMENT9 VertexElementFactoryDX9::CreateElement(VertexElementType::EElement eElement)
{
	// ϐp
	D3DVERTEXELEMENT9 sElement;
	ZeroMemory(&sElement, sizeof(sElement));


	// ̎ނŕ
	switch (eElement)
	{
		// ʒuȂ
		case VertexElementType::eELEMENT_POSITION:			CreatePosition(&sElement);
			break;

		// FȂ
		case VertexElementType::eELEMENT_COLOR:				CreateColor(&sElement);
			break;

		// @Ȃ
		case VertexElementType::eELEMENT_NORMAL:			CreateNormal(&sElement);
			break;

		// UVȂ
		case VertexElementType::eELEMENT_UV:				CreateUV(&sElement);
			break;

		// {[CfbNX쐬
		case VertexElementType::eELEMENT_BONE_INDEX:		CreateBoneIndex(&sElement);
			break;

		// {[EFCg쐬
		case VertexElementType::eELEMENT_BONE_WEIGHT:		CreateBoneWeight(&sElement);
			break;

		// CX^XCfbNX쐬
		case VertexElementType::eELEMENT_INSTANCE_INDEX:	CreateInstanceIndex(&sElement);
			break;


		// ADD:ɂFX


		// IȂ
		case VertexElementType::eELEMENT_END:		CreateEnd(&sElement);
			break;

		// P[XOȂ
		default:									HALT(_T("̒_I܂B"));
			break;
	}


	// Ԃ
	return sElement;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ʒu쐬
void VertexElementFactoryDX9::CreatePosition(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_POSITION;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_FLOAT3;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_POSITION;
}

/// F쐬
void VertexElementFactoryDX9::CreateColor(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_COLOR;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_D3DCOLOR;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_COLOR;
}

/// @쐬
void VertexElementFactoryDX9::CreateNormal(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_NORMAL;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_FLOAT3;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_NORMAL;
}

/// UV쐬
void VertexElementFactoryDX9::CreateUV(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_UV;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_FLOAT2;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_TEXCOORD;
}

/// {[CfbNX쐬
void VertexElementFactoryDX9::CreateBoneIndex(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_BONE_INDEX;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_UBYTE4;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_BLENDINDICES;
}

/// {[EFCg쐬
void VertexElementFactoryDX9::CreateBoneWeight(D3DVERTEXELEMENT9* pOut)
{
	// Xg[ݒ
	pOut->Stream = VertexStreamType::eSTREAM_BONE_WEIGHT;

	// ^ݒ
	pOut->Type = D3DDECLTYPE_FLOAT4;

	// prݒ
	pOut->Usage = D3DDECLUSAGE_BLENDWEIGHT;
}

/// CX^XCfbNX쐬
void VertexElementFactoryDX9::CreateInstanceIndex(D3DVERTEXELEMENT9* pOut)
{
	pOut->Stream = VertexStreamType::eSTREAM_INSTANCE_INDEX;
	pOut->Type = D3DDECLTYPE_FLOAT1;
	pOut->Usage = D3DDECLUSAGE_TEXCOORD;
	pOut->UsageIndex = 1;
}


// ADD:ɂFX


/// I쐬
void VertexElementFactoryDX9::CreateEnd(D3DVERTEXELEMENT9* pOut)
{
	// MEMO:IƂ݂Ȃl D3DDECL_END ƒ`Ă܂Â܂܎gȂ̂œWĴĂ܂B
	D3DVERTEXELEMENT9 sElementEnd = { 0xFF, 0, D3DDECLTYPE_UNUSED, 0, 0, 0 };
	memcpy(pOut, &sElementEnd, sizeof(sElementEnd));
}