#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
VertexBufferDX9::VertexBufferDX9() :
mSize(-1),
mCount(-1),
mStride(-1)
{
}

/// fXgN^
VertexBufferDX9::~VertexBufferDX9()
{
}

/// obt@擾
IDirect3DVertexBuffer9* VertexBufferDX9::GetBuffer()
{
	return mPBuffer.GetInterface();
}

/// _f[^zݒ
void VertexBufferDX9::SetVertices(void* pVertices, u32 count, unsigned size)
{
	// TCYێ
	mSize = size;

	// _ێ
	mCount = count;

	// XgChێ
	mStride = size / count;

	
	// foCX擾
	GraphicsDeviceDX9* pRenderDeviceDX9 = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pRenderDeviceDX9->GetDevice();


	// o[ebNXobt@쐬
	mPBuffer.SetInterfacePtr(NULL);
	HRESULT hr = pDevice->CreateVertexBuffer(mSize, 0, 0, D3DPOOL_MANAGED, mPBuffer.ToCreator(), NULL);
	if (FAILED(hr))
	{
		HALT(_T("o[ebNXobt@̍쐬Ɏs܂B\n"));
	}

	// o[ebNXobt@ɒ_Rs[
	void* pV = NULL;
	hr = mPBuffer->Lock(0, 0, (void**)&pV, 0);
	if (FAILED(hr))
	{
		HALT(_T("_obt@̃bNɎs܂B\n"));
	}
	memcpy(pV, pVertices, mSize);
	mPBuffer->Unlock();
	if (FAILED(hr))
	{
		HALT(_T("_obt@̃AbNɎs܂B\n"));
	}
}

/// TCY擾
unsigned VertexBufferDX9::GetSize() const
{
	return mSize;
}

/// 擾
u32 VertexBufferDX9::GetVertexCount() const
{
	return mCount;
}

/// XgCh擾
int VertexBufferDX9::GetStride() const
{
	return mStride;
}
